/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphdb.Resource;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreResource;
import org.neo4j.storageengine.api.TransactionId;

public final class StoreSnapshot
implements AutoCloseable {
    private final Stream<StoreResource> unrecoverableFiles;
    private final Path[] recoverableFiles;
    private final TransactionId lastAppliedTransactionId;
    private final StoreId storeId;
    private final Resource checkPointMutex;

    public StoreSnapshot(Stream<StoreResource> unrecoverableFiles, Path[] recoverableFiles, TransactionId lastAppliedTransactionId, StoreId storeId, Resource checkPointMutex) {
        this.unrecoverableFiles = unrecoverableFiles;
        this.recoverableFiles = recoverableFiles;
        this.lastAppliedTransactionId = lastAppliedTransactionId;
        this.storeId = storeId;
        this.checkPointMutex = checkPointMutex;
    }

    public Stream<StoreResource> unrecoverableFiles() {
        return this.unrecoverableFiles;
    }

    public Path[] recoverableFiles() {
        return this.recoverableFiles;
    }

    public StoreId storeId() {
        return this.storeId;
    }

    public TransactionId lastAppliedTransactionId() {
        return this.lastAppliedTransactionId;
    }

    @Override
    public void close() {
        this.unrecoverableFiles.close();
        this.checkPointMutex.close();
    }

    @FunctionalInterface
    public static interface Factory {
        public Optional<StoreSnapshot> createStoreSnapshot() throws IOException;
    }
}

