/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.util.Optional;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.AppendBatchInfo;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;

public class EmptyLogTailMetadata
implements LogTailMetadata {
    static final LogPosition START_POSITION = new LogPosition(0L, 64L);
    public static final AppendBatchInfo EMPTY_APPEND_BATCH_INFO = new AppendBatchInfo(1L, START_POSITION);
    private final KernelVersion kernelVersion;

    public EmptyLogTailMetadata(Config config) {
        this.kernelVersion = KernelVersion.getLatestVersion(config);
    }

    @Override
    public boolean isRecoveryRequired() {
        return false;
    }

    @Override
    public long getCheckpointLogVersion() {
        return 0L;
    }

    @Override
    public KernelVersion kernelVersion() {
        return this.kernelVersion;
    }

    @Override
    public long getLogVersion() {
        return 0L;
    }

    @Override
    public Optional<StoreId> getStoreId() {
        return Optional.empty();
    }

    @Override
    public boolean logsMissing() {
        return true;
    }

    @Override
    public TransactionId getLastCommittedTransaction() {
        return TransactionIdStore.emptyVersionedTransaction(this.kernelVersion);
    }

    @Override
    public LogPosition getLastTransactionLogPosition() {
        return START_POSITION;
    }

    @Override
    public boolean hasUnreadableBytesInCheckpointLogs() {
        return false;
    }

    @Override
    public Optional<CheckpointInfo> getLastCheckPoint() {
        return Optional.empty();
    }

    @Override
    public long getLastCheckpointedAppendIndex() {
        return 1L;
    }

    @Override
    public AppendBatchInfo lastBatch() {
        return EMPTY_APPEND_BATCH_INFO;
    }
}

