/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.internal.helpers.NameUtil;
import org.neo4j.internal.kernel.api.security.PropertyRule;
import org.neo4j.internal.kernel.api.security.Segment;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public interface PatternSegment
extends Segment {
    public static final Set<String> ALL_LABELS = Set.of();

    default public String labelsString() {
        return this.labels().isEmpty() ? "" : this.labels().stream().sorted().map(NameUtil::escapeName).collect(Collectors.joining("|", ":", ""));
    }

    default public String nodeString() {
        return String.format("(n%s)", this.labelsString());
    }

    default public String propertyString() {
        return String.format("n.%s", NameUtil.escapeName((String)this.property()));
    }

    public Set<String> labels();

    public String property();

    public String pattern();

    @Override
    default public boolean satisfies(Segment segment) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public String toCypherSnippet() {
        return String.format("FOR %s", this.pattern());
    }

    public record NullPatternSegment(Set<String> labels, String property, PropertyRule.NullOperator operator) implements PatternSegment
    {
        public NullPatternSegment(String property, PropertyRule.NullOperator operator) {
            this(ALL_LABELS, property, operator);
        }

        public NullPatternSegment {
            Preconditions.requireNonNull(labels, (String)"labels must not be null");
            Preconditions.requireNonNull((Object)property, (String)"property must not be null");
        }

        @Override
        public String pattern() {
            return String.format("%s WHERE %s", this.nodeString(), this.operator.toPredicateString(this.propertyString()));
        }

        @Override
        public String toString() {
            return String.format("FOR(%s)", this.pattern());
        }
    }

    public record ValuePatternSegment(Set<String> labels, String property, Value value, PropertyRule.ComparisonOperator operator) implements PatternSegment
    {
        public ValuePatternSegment(String property, Value value, PropertyRule.ComparisonOperator operator) {
            this(ALL_LABELS, property, value, operator);
        }

        public ValuePatternSegment {
            Preconditions.requireNonNull(labels, (String)"labels must not be null");
            Preconditions.requireNonNull((Object)property, (String)"property must not be null");
            Preconditions.requireNonNull((Object)value, (String)"value must not be null");
            Preconditions.checkArgument((value != Values.NO_VALUE ? 1 : 0) != 0, (String)"value must not be NO_VALUE. Use NullPatternSegment for this purpose.");
        }

        @Override
        public String pattern() {
            return String.format("%s WHERE %s", this.nodeString(), this.operator.toPredicateString(this.propertyString(), this.prettyPrintValue(this.value)));
        }

        @Override
        public String toString() {
            return String.format("FOR(%s)", this.pattern());
        }

        private String prettyPrintValue(Value value) {
            String method = null;
            String prettyPrintedValue = value.prettyPrint();
            if (value instanceof DateValue) {
                method = "date";
            } else if (value instanceof LocalDateTimeValue) {
                method = "localdatetime";
            } else if (value instanceof DateTimeValue) {
                method = "datetime";
            } else if (value instanceof LocalTimeValue) {
                method = "localtime";
            } else if (value instanceof TimeValue) {
                method = "time";
            } else if (value instanceof DurationValue) {
                method = "duration";
            } else if (value instanceof PointValue) {
                prettyPrintedValue = value.toString();
            }
            return method == null ? prettyPrintedValue : String.format("%s('%s')", method, prettyPrintedValue);
        }
    }
}

