/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingMigrator;
import org.neo4j.logging.InternalLog;
import org.neo4j.storageengine.api.StorageEngineFactory;

public class DeprecatedFormatWarning {
    private static final String FORMAT_INFO = "For details on deprecated store formats, see https://neo4j.com/docs/store-format-deprecations.";

    public static String getFormatWarning(String databaseName, String format) {
        return "The database: " + databaseName + " has a deprecated store format: " + format + ". For details on deprecated store formats, see https://neo4j.com/docs/store-format-deprecations.";
    }

    public static String getTargetFormatWarning(String format) {
        return "The targeted store format: " + format + " is deprecated. For details on deprecated store formats, see https://neo4j.com/docs/store-format-deprecations.";
    }

    public static String getConfigFormatWarning(String format) {
        return "The specified format: " + format + " set in the config is deprecated. For details on deprecated store formats, see https://neo4j.com/docs/store-format-deprecations.";
    }

    public static class FormatDeprecationWarningMigrator
    implements SettingMigrator {
        public void migrate(Map<String, String> values, Map<String, String> defaultValues, InternalLog log) {
            String format = values.get(GraphDatabaseSettings.db_format.name());
            if (StringUtils.isNotBlank((CharSequence)format) && StorageEngineFactory.isFormatDeprecated(format)) {
                log.warn(DeprecatedFormatWarning.getConfigFormatWarning(format));
            }
        }
    }
}

