/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.storageengine.api.DirectedTypes;
import org.neo4j.storageengine.api.RelationshipSelection;

public final class RelationshipSelections {
    private RelationshipSelections() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static RelationshipTraversalCursor outgoingCursor(CursorFactory cursors, NodeCursor node, int[] types, CursorContext cursorContext) {
        return RelationshipSelections.relationshipsCursor(cursors.allocateRelationshipTraversalCursor(cursorContext), node, types, Direction.OUTGOING);
    }

    public static RelationshipTraversalCursor outgoingCursor(RelationshipTraversalCursor traversalCursor, NodeCursor node, int[] types) {
        return RelationshipSelections.relationshipsCursor(traversalCursor, node, types, Direction.OUTGOING);
    }

    public static RelationshipTraversalCursor incomingCursor(RelationshipTraversalCursor traversalCursor, NodeCursor node, int[] types) {
        return RelationshipSelections.relationshipsCursor(traversalCursor, node, types, Direction.INCOMING);
    }

    public static RelationshipTraversalCursor incomingCursor(CursorFactory cursors, NodeCursor node, int[] types, CursorContext cursorContext) {
        return RelationshipSelections.relationshipsCursor(cursors.allocateRelationshipTraversalCursor(cursorContext), node, types, Direction.INCOMING);
    }

    public static RelationshipTraversalCursor allCursor(CursorFactory cursors, NodeCursor node, int[] types, CursorContext cursorContext) {
        return RelationshipSelections.relationshipsCursor(cursors.allocateRelationshipTraversalCursor(cursorContext), node, types, Direction.BOTH);
    }

    public static RelationshipTraversalCursor allCursor(RelationshipTraversalCursor traversalCursor, NodeCursor node, int[] types) {
        node.relationships(traversalCursor, RelationshipSelection.selection(types, Direction.BOTH));
        return traversalCursor;
    }

    public static RelationshipTraversalCursor multiTypeMultiDirectionCursor(RelationshipTraversalCursor traversalCursor, NodeCursor node, DirectedTypes directedTypes) {
        node.relationships(traversalCursor, RelationshipSelection.selection(directedTypes));
        return traversalCursor;
    }

    public static RelationshipTraversalCursor relationshipsCursor(RelationshipTraversalCursor traversalCursor, NodeCursor node, int[] types, Direction outgoing) {
        node.relationships(traversalCursor, RelationshipSelection.selection(types, outgoing));
        return traversalCursor;
    }

    public static <T> ResourceIterator<T> outgoingIterator(CursorFactory cursors, NodeCursor node, int[] types, RelationshipFactory<T> factory, CursorContext cursorContext) {
        return new RelationshipEntityIterator<T>(RelationshipSelections.outgoingCursor(cursors, node, types, cursorContext), factory);
    }

    public static <T> ResourceIterator<T> incomingIterator(CursorFactory cursors, NodeCursor node, int[] types, RelationshipFactory<T> factory, CursorContext cursorContext) {
        return new RelationshipEntityIterator<T>(RelationshipSelections.incomingCursor(cursors, node, types, cursorContext), factory);
    }

    public static <T> ResourceIterator<T> allIterator(CursorFactory cursors, NodeCursor node, int[] types, RelationshipFactory<T> factory, CursorContext cursorContext) {
        return new RelationshipEntityIterator<T>(RelationshipSelections.allCursor(cursors, node, types, cursorContext), factory);
    }

    private static class RelationshipEntityIterator<T>
    extends PrefetchingResourceIterator<T> {
        private final RelationshipTraversalCursor relationshipTraversalCursor;
        private final RelationshipFactory<T> factory;

        RelationshipEntityIterator(RelationshipTraversalCursor relationshipTraversalCursor, RelationshipFactory<T> factory) {
            this.relationshipTraversalCursor = relationshipTraversalCursor;
            this.factory = factory;
        }

        public void close() {
            this.relationshipTraversalCursor.close();
        }

        protected T fetchNextOrNull() {
            if (this.relationshipTraversalCursor.next()) {
                return this.factory.relationship(this.relationshipTraversalCursor);
            }
            this.close();
            return null;
        }
    }
}

