/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import java.util.function.Function;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.token.api.TokenIdPrettyPrinter;

public class NodePropertyExistenceException
extends ConstraintValidationException {
    private final long nodeId;
    private final LabelSchemaDescriptor schema;

    public NodePropertyExistenceException(LabelSchemaDescriptor schema, Function<LabelSchemaDescriptor, ConstraintDescriptor> constraintFunc, ConstraintValidationException.Phase phase, long nodeId, TokenNameLookup tokenNameLookup) {
        super(constraintFunc.apply(schema), phase, String.format("Node(%d)", nodeId), tokenNameLookup);
        this.schema = schema;
        this.nodeId = nodeId;
    }

    public NodePropertyExistenceException(ErrorGqlStatusObject gqlStatusObject, LabelSchemaDescriptor schema, Function<LabelSchemaDescriptor, ConstraintDescriptor> constraintFunc, ConstraintValidationException.Phase phase, long nodeId, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, constraintFunc.apply(schema), phase, String.format("Node(%d)", nodeId), tokenNameLookup);
        this.schema = schema;
        this.nodeId = nodeId;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        boolean pluralProps = this.schema.getPropertyIds().length > 1;
        String propertyNoun = pluralProps ? "properties" : "property";
        String sep = pluralProps ? "" : "`";
        String props = pluralProps ? TokenIdPrettyPrinter.niceQuotedProperties((TokenNameLookup)tokenNameLookup, (int[])this.schema.getPropertyIds()) : tokenNameLookup.propertyKeyGetName(this.schema.getPropertyId());
        return String.format("Node(%d) with label `%s` must have the %s %s%s%s", this.nodeId, tokenNameLookup.labelGetName(this.schema.getLabelId()), propertyNoun, sep, props, sep);
    }
}

