/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import org.neo4j.internal.helpers.Strings;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.log4j.LogExtended;
import org.neo4j.logging.log4j.Neo4jLogMessage;
import org.neo4j.logging.log4j.StructureAwareMessage;

public abstract class AbstractSecurityLog
extends LifecycleAdapter {
    LogExtended inner;

    public void setLog(LogExtended inner) {
        this.inner = inner;
    }

    public void debug(String message) {
        this.inner.debug((Neo4jLogMessage)new SecurityLogLine(message));
    }

    public void debug(SecurityContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.debug((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), subject.executingUser(), message, subject.authenticatedUser()));
    }

    public void info(String message) {
        this.inner.info((Neo4jLogMessage)new SecurityLogLine(message));
    }

    public void info(LoginContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.info((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), null, subject.executingUser(), message, subject.authenticatedUser()));
    }

    public void info(SecurityContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.info((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), subject.executingUser(), message, subject.authenticatedUser()));
    }

    public void warn(String message) {
        this.inner.warn((Neo4jLogMessage)new SecurityLogLine(message));
    }

    public void warn(SecurityContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.warn((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), subject.executingUser(), message, subject.authenticatedUser()));
    }

    public void error(String message) {
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(message));
    }

    public void error(ClientConnectionInfo connectionInfo, String message) {
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(connectionInfo, null, null, message, null));
    }

    public void error(LoginContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), null, subject.executingUser(), message, subject.authenticatedUser()));
    }

    public void error(LoginContext context, String database, String message) {
        AuthSubject subject = context.subject();
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), database, subject.executingUser(), message, subject.authenticatedUser()));
    }

    public void error(SecurityContext context, String message) {
        AuthSubject subject = context.subject();
        this.inner.error((Neo4jLogMessage)new SecurityLogLine(context.connectionInfo(), context.database(), subject.executingUser(), message, subject.authenticatedUser()));
    }

    public boolean isDebugEnabled() {
        return this.inner.isDebugEnabled();
    }

    static class SecurityLogLine
    extends StructureAwareMessage {
        private final String executingUser;
        private final String sourceString;
        private final String message;
        private final String authenticatedUser;
        private final String database;

        SecurityLogLine(String message) {
            this.sourceString = null;
            this.database = null;
            this.executingUser = null;
            this.authenticatedUser = null;
            this.message = message;
        }

        SecurityLogLine(ClientConnectionInfo connectionInfo, String database, String executingUser, String message, String authenticatedUser) {
            this.sourceString = connectionInfo.asConnectionDetails();
            this.database = database;
            this.executingUser = executingUser;
            this.message = message.replaceAll("\\R+", " ");
            this.authenticatedUser = authenticatedUser;
        }

        public void asString(StringBuilder sb) {
            if (this.executingUser != null && this.executingUser.length() > 0) {
                if (this.executingUser.equals(this.authenticatedUser)) {
                    sb.append("[").append(Strings.escape((String)this.executingUser)).append("]: ");
                } else {
                    sb.append(String.format("[%s:%s]: ", Strings.escape((String)this.authenticatedUser), Strings.escape((String)this.executingUser)));
                }
            }
            sb.append(this.message);
        }

        public void asStructure(StructureAwareMessage.FieldConsumer fieldConsumer) {
            fieldConsumer.add("type", "security");
            fieldConsumer.add("source", this.sourceString);
            if (this.database != null) {
                fieldConsumer.add("database", this.database);
            }
            if (this.executingUser != null && this.executingUser.length() > 0) {
                fieldConsumer.add("username", this.executingUser);
                fieldConsumer.add("executingUser", this.executingUser);
            }
            if (this.authenticatedUser != null && this.authenticatedUser.length() > 0) {
                fieldConsumer.add("authenticatedUser", this.authenticatedUser);
            }
            fieldConsumer.add("message", this.message);
        }
    }
}

