/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.OptionalLong;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.util.Preconditions;

public class IndexQueryConstraints {
    private static final IndexQueryConstraints UNCONSTRAINED = new IndexQueryConstraints(IndexOrder.NONE, false, false, false, 0L, 0L);
    private static final IndexQueryConstraints UNORDERED_VALUES = new IndexQueryConstraints(IndexOrder.NONE, true, false, false, 0L, 0L);
    private final IndexOrder order;
    private final boolean needsValues;
    private final boolean hasSkip;
    private final boolean hasLimit;
    private final long skip;
    private final long limit;

    private IndexQueryConstraints(IndexOrder order, boolean needsValues, boolean hasSkip, boolean hasLimit, long skip, long limit) {
        this.order = order;
        this.needsValues = needsValues;
        this.hasSkip = hasSkip;
        this.hasLimit = hasLimit;
        this.skip = skip;
        this.limit = limit;
    }

    public static IndexQueryConstraints unconstrained() {
        return UNCONSTRAINED;
    }

    public static IndexQueryConstraints unorderedValues() {
        return UNORDERED_VALUES;
    }

    public static IndexQueryConstraints unordered(boolean needsValues) {
        return needsValues ? IndexQueryConstraints.unorderedValues() : IndexQueryConstraints.unconstrained();
    }

    public static IndexQueryConstraints ordered(IndexOrder order) {
        return IndexQueryConstraints.constrained(order, false);
    }

    public static IndexQueryConstraints constrained(IndexOrder order, boolean needsValues) {
        return new IndexQueryConstraints(order, needsValues, false, false, 0L, 0L);
    }

    public IndexQueryConstraints skip(long skip) {
        Preconditions.checkState((skip >= 0L ? 1 : 0) != 0, (String)"Skip argument cannot be negative: %s.", (Object[])new Object[]{skip});
        if (this.hasLimit) {
            Preconditions.requireNoLongAddOverflow((long)skip, (long)this.limit, (String)"SKIP (%s) and LIMIT (%s) combined are too large; would overflow 64-bit signed integer.");
        }
        return new IndexQueryConstraints(this.order, this.needsValues, true, this.hasLimit, skip, this.limit);
    }

    public IndexQueryConstraints limit(long limit) {
        Preconditions.checkState((limit >= 0L ? 1 : 0) != 0, (String)"Limit argument cannot be negative: %s.", (Object[])new Object[]{limit});
        if (this.hasSkip) {
            Preconditions.requireNoLongAddOverflow((long)this.skip, (long)limit, (String)"SKIP (%s) and LIMIT (%s) are too large; would overflow 64-bit signed integer.");
        }
        return new IndexQueryConstraints(this.order, this.needsValues, this.hasSkip, true, this.skip, limit);
    }

    public boolean isOrdered() {
        return this.order != IndexOrder.NONE;
    }

    public boolean needsValues() {
        return this.needsValues;
    }

    public IndexOrder order() {
        return this.order;
    }

    public OptionalLong skip() {
        return this.hasSkip ? OptionalLong.of(this.skip) : OptionalLong.empty();
    }

    public OptionalLong limit() {
        return this.hasLimit ? OptionalLong.of(this.limit) : OptionalLong.empty();
    }
}

