/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.schema;

import java.util.Optional;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.values.storable.ValueCategory;

public class IndexDescriptor
implements SchemaDescriptorSupplier,
IndexReference {
    protected final SchemaDescriptor schema;
    protected final Type type;
    protected final Optional<String> userSuppliedName;
    protected final IndexProviderDescriptor providerDescriptor;

    IndexDescriptor(IndexDescriptor indexDescriptor) {
        this(indexDescriptor.schema, indexDescriptor.type, indexDescriptor.userSuppliedName, indexDescriptor.providerDescriptor);
    }

    public IndexDescriptor(SchemaDescriptor schema, Type type, Optional<String> userSuppliedName, IndexProviderDescriptor providerDescriptor) {
        this.schema = schema;
        this.type = type;
        this.userSuppliedName = userSuppliedName;
        this.providerDescriptor = providerDescriptor;
    }

    public Type type() {
        return this.type;
    }

    @Override
    public SchemaDescriptor schema() {
        return this.schema;
    }

    @Override
    public boolean isUnique() {
        return this.type == Type.UNIQUE;
    }

    @Override
    public int[] properties() {
        return this.schema.getPropertyIds();
    }

    @Override
    public String providerKey() {
        return this.providerDescriptor.getKey();
    }

    @Override
    public String providerVersion() {
        return this.providerDescriptor.getVersion();
    }

    @Override
    public String name() {
        return this.userSuppliedName.orElse("Unnamed index");
    }

    public IndexProviderDescriptor providerDescriptor() {
        return this.providerDescriptor;
    }

    @Override
    public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
        return ORDER_NONE;
    }

    @Override
    public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
        return IndexValueCapability.NO;
    }

    @Override
    public boolean isFulltextIndex() {
        return false;
    }

    @Override
    public boolean isEventuallyConsistent() {
        return false;
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        return String.format("Index( %s, %s )", this.type.name(), this.schema.userDescription(tokenNameLookup));
    }

    public boolean equals(Object o) {
        if (o instanceof IndexDescriptor) {
            IndexDescriptor that = (IndexDescriptor)o;
            return this.type() == that.type() && this.schema().equals(that.schema());
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode() & this.schema.hashCode();
    }

    public String toString() {
        return this.userDescription(SchemaUtil.idTokenNameLookup);
    }

    public StoreIndexDescriptor withId(long id) {
        this.assertValidId(id, "id");
        return new StoreIndexDescriptor(this, id);
    }

    public StoreIndexDescriptor withIds(long id, long owningConstraintId) {
        this.assertValidId(id, "id");
        this.assertValidId(owningConstraintId, "owning constraint id");
        return new StoreIndexDescriptor(this, id, owningConstraintId);
    }

    void assertValidId(long id, String idName) {
        if (id < 0L) {
            throw new IllegalArgumentException("A " + this.getClass().getSimpleName() + " " + idName + " must be positive, got " + id);
        }
    }

    public Optional<String> getUserSuppliedName() {
        return this.userSuppliedName;
    }

    public static enum Type {
        GENERAL,
        UNIQUE;

    }
}

