/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import org.neo4j.storageengine.api.CommandVersion;

public enum TransactionApplicationMode {
    INTERNAL(false, false, false, true, CommandVersion.AFTER),
    EXTERNAL(true, true, false, true, CommandVersion.AFTER),
    RECOVERY(true, true, true, true, CommandVersion.AFTER),
    REVERSE_RECOVERY(false, false, true, false, CommandVersion.BEFORE);

    private final boolean needsHighIdTracking;
    private final boolean needsCacheInvalidation;
    private final boolean needsIdempotencyChecks;
    private final boolean indexesAndCounts;
    private final CommandVersion version;

    private TransactionApplicationMode(boolean needsHighIdTracking, boolean needsCacheInvalidation, boolean ensureIdempotency, boolean indexesAndCounts, CommandVersion version) {
        this.needsHighIdTracking = needsHighIdTracking;
        this.needsCacheInvalidation = needsCacheInvalidation;
        this.needsIdempotencyChecks = ensureIdempotency;
        this.indexesAndCounts = indexesAndCounts;
        this.version = version;
    }

    public boolean needsHighIdTracking() {
        return this.needsHighIdTracking;
    }

    public boolean needsCacheInvalidationOnUpdates() {
        return this.needsCacheInvalidation;
    }

    public boolean needsIdempotencyChecks() {
        return this.needsIdempotencyChecks;
    }

    public boolean needsAuxiliaryStores() {
        return this.indexesAndCounts;
    }

    public CommandVersion version() {
        return this.version;
    }
}

