/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;

abstract class RelationshipSparseSelection {
    protected RelationshipTraversalCursor cursor;
    private int[] types;
    private Dir targetDirection;
    private boolean onRelationship;
    private boolean firstNext;

    RelationshipSparseSelection() {
    }

    public void outgoing(RelationshipTraversalCursor relationshipCursor) {
        this.init(relationshipCursor, null, Dir.OUT);
    }

    public void outgoing(RelationshipTraversalCursor relationshipCursor, int[] types) {
        this.init(relationshipCursor, types, Dir.OUT);
    }

    public void incoming(RelationshipTraversalCursor relationshipCursor) {
        this.init(relationshipCursor, null, Dir.IN);
    }

    public void incoming(RelationshipTraversalCursor relationshipCursor, int[] types) {
        this.init(relationshipCursor, types, Dir.IN);
    }

    public void all(RelationshipTraversalCursor relationshipCursor) {
        this.init(relationshipCursor, null, Dir.BOTH);
    }

    public void all(RelationshipTraversalCursor relationshipCursor, int[] types) {
        this.init(relationshipCursor, types, Dir.BOTH);
    }

    private void init(RelationshipTraversalCursor relationshipCursor, int[] types, Dir targetDirection) {
        this.cursor = relationshipCursor;
        this.types = types;
        this.targetDirection = targetDirection;
        this.onRelationship = false;
        this.firstNext = true;
    }

    protected boolean fetchNext() {
        if (this.onRelationship || this.firstNext) {
            this.firstNext = false;
            do {
                this.onRelationship = this.cursor.next();
            } while (this.onRelationship && (!this.correctDirection() || !this.correctType()));
        }
        if (this.onRelationship) {
            this.setRelationship(this.cursor.relationshipReference(), this.cursor.sourceNodeReference(), this.cursor.label(), this.cursor.targetNodeReference());
        }
        return this.onRelationship;
    }

    protected abstract void setRelationship(long var1, long var3, int var5, long var6);

    private boolean correctDirection() {
        return this.targetDirection == Dir.BOTH || this.targetDirection == Dir.OUT && this.cursor.originNodeReference() == this.cursor.sourceNodeReference() || this.targetDirection == Dir.IN && this.cursor.originNodeReference() == this.cursor.targetNodeReference();
    }

    private boolean correctType() {
        return this.types == null || ArrayUtils.contains((int[])this.types, (int)this.cursor.label());
    }

    public void close() {
        try {
            if (this.cursor != null) {
                this.cursor.close();
            }
        }
        finally {
            this.cursor = null;
        }
    }

    private static enum Dir {
        OUT,
        IN,
        BOTH;

    }
}

