/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.kernel.api.security.StaticAccessMode;
import org.neo4j.kernel.database.PrivilegeDatabaseReference;

public abstract class LoginContext {
    protected final AuthSubject subject;
    private final ClientConnectionInfo connectionInfo;
    private final String token;
    public static final LoginContext AUTH_DISABLED = LoginContext.fullAccess(ClientConnectionInfo.EMBEDDED_CONNECTION);

    public LoginContext(AuthSubject subject, ClientConnectionInfo connectionInfo) {
        this.subject = subject;
        this.connectionInfo = connectionInfo;
        this.token = null;
    }

    public LoginContext(AuthSubject subject, ClientConnectionInfo connectionInfo, String token) {
        this.subject = subject;
        this.connectionInfo = connectionInfo;
        this.token = token;
    }

    public AuthSubject subject() {
        return this.subject;
    }

    public ClientConnectionInfo connectionInfo() {
        return this.connectionInfo;
    }

    public boolean impersonating() {
        return !Objects.equals(this.subject.executingUser(), this.subject.authenticatedUser());
    }

    public boolean nativelyAuthenticated() {
        return this.subject.nativelyAuthenticated();
    }

    public abstract SecurityContext authorize(IdLookup var1, PrivilegeDatabaseReference var2, AbstractSecurityLog var3, long var4);

    public static LoginContext fullAccess(ClientConnectionInfo connectionInfo) {
        return new LoginContext(AuthSubject.AUTH_DISABLED, connectionInfo){

            @Override
            public SecurityContext authorize(IdLookup idLookup, PrivilegeDatabaseReference dbReference, AbstractSecurityLog securityLog, long timeOfEvaluationMillis) {
                return SecurityContext.authDisabled(StaticAccessMode.FULL, this.connectionInfo(), dbReference.name());
            }
        };
    }

    public String oidcToken() {
        return this.token;
    }

    public LoginContext withExternalShardAccess() {
        return this;
    }

    public static interface IdLookup {
        public static final int[] NO_SUCH_PROCEDURE = ArrayUtils.EMPTY_INT_ARRAY;
        public static final IdLookup EMPTY = new IdLookup(){

            @Override
            public int getPropertyKeyId(String name) {
                return -1;
            }

            @Override
            public int getLabelId(String name) {
                return -1;
            }

            @Override
            public int getRelTypeId(String name) {
                return -1;
            }

            @Override
            public int[] getProcedureIds(String procedureGlobbing) {
                return NO_SUCH_PROCEDURE;
            }

            @Override
            public int[] getAdminProcedureIds() {
                return NO_SUCH_PROCEDURE;
            }

            @Override
            public int[] getFunctionIds(String functionGlobbing) {
                return NO_SUCH_PROCEDURE;
            }

            @Override
            public int[] getAggregatingFunctionIds(String functionGlobbing) {
                return NO_SUCH_PROCEDURE;
            }

            @Override
            public boolean isCachableLookup() {
                return false;
            }

            @Override
            public boolean isStale() {
                return true;
            }
        };

        public int getPropertyKeyId(String var1);

        public int getLabelId(String var1);

        public int getRelTypeId(String var1);

        public int[] getProcedureIds(String var1);

        public int[] getAdminProcedureIds();

        public int[] getFunctionIds(String var1);

        public int[] getAggregatingFunctionIds(String var1);

        public boolean isCachableLookup();

        public boolean isStale();
    }
}

