/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.neo4j.util.Preconditions;

public class LogPosition
implements Comparable<LogPosition> {
    public static final LogPosition UNSPECIFIED = new UnspecifiedLogPosition();
    private final long logVersion;
    private final long byteOffset;

    private LogPosition() {
        this.logVersion = -1L;
        this.byteOffset = -1L;
    }

    public LogPosition(long logVersion, long byteOffset) {
        this.logVersion = Preconditions.requireNonNegative((long)logVersion);
        this.byteOffset = Preconditions.requireNonNegative((long)byteOffset);
    }

    public long getLogVersion() {
        return this.logVersion;
    }

    public long getByteOffset() {
        return this.byteOffset;
    }

    public String toString() {
        return "LogPosition{logVersion=" + this.logVersion + ", byteOffset=" + this.byteOffset + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogPosition that = (LogPosition)o;
        return this.byteOffset == that.byteOffset && this.logVersion == that.logVersion;
    }

    public int hashCode() {
        int result = (int)(this.logVersion ^ this.logVersion >>> 32);
        result = 31 * result + (int)(this.byteOffset ^ this.byteOffset >>> 32);
        return result;
    }

    public boolean isAfterOrSame(LogPosition logPosition) {
        return !this.isBefore(logPosition);
    }

    public boolean isBefore(LogPosition logPosition) {
        return this.compareTo(logPosition) < 0;
    }

    @Override
    public int compareTo(LogPosition o) {
        if (this.logVersion != o.logVersion) {
            return Long.compare(this.logVersion, o.logVersion);
        }
        return Long.compare(this.byteOffset, o.byteOffset);
    }

    private static final class UnspecifiedLogPosition
    extends LogPosition {
        private UnspecifiedLogPosition() {
        }

        @Override
        public long getLogVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getByteOffset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return "UNSPECIFIED";
        }
    }
}

