/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Arrays;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;

public class TokenIndexEntryUpdate
extends IndexEntryUpdate {
    private final int[] before;
    private final int[] values;
    private final boolean logical;

    TokenIndexEntryUpdate(long entityId, IndexDescriptor indexKey, int[] before, int[] values, boolean logical) {
        super(entityId, indexKey, UpdateMode.CHANGED);
        this.before = before;
        this.values = values;
        this.logical = logical;
    }

    public int[] values() {
        return this.values;
    }

    public int[] beforeValues() {
        if (this.before == null) {
            throw new UnsupportedOperationException("beforeValues is only valid for `UpdateMode.CHANGED");
        }
        return this.before;
    }

    public boolean isLogical() {
        return this.logical;
    }

    @Override
    public long roughSizeOfUpdate() {
        return HeapEstimator.sizeOf((int[])this.values) + (this.updateMode() == UpdateMode.CHANGED ? HeapEstimator.sizeOf((int[])this.before) : 0L);
    }

    @Override
    protected boolean valueEquals(IndexEntryUpdate o) {
        if (!(o instanceof TokenIndexEntryUpdate)) {
            return false;
        }
        TokenIndexEntryUpdate that = (TokenIndexEntryUpdate)o;
        if (!Arrays.equals(this.before, that.before)) {
            return false;
        }
        return Arrays.equals(this.values, that.values);
    }

    @Override
    protected int valueHash() {
        int result = Arrays.hashCode(this.before);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    @Override
    protected String valueToString() {
        return String.format("beforeValues=%s, values=%s", Arrays.toString(this.before), Arrays.toString(this.values));
    }

    @Override
    public IndexEntryUpdate withEntityId(long entityId) {
        return IndexEntryUpdate.change(entityId, this.indexKey(), this.before, this.values);
    }
}

