/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.LongPredicate;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntriesReader;
import org.neo4j.kernel.api.index.IndexEntryConflictHandler;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.SwallowingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.index.schema.EntityTokenRange;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.values.storable.Value;

public interface IndexAccessor
extends Closeable,
ConsistencyCheckable,
MinimalIndexAccessor {
    public static final long UNKNOWN_NUMBER_OF_ENTRIES = -1L;
    public static final IndexAccessor EMPTY = new Adapter();

    public IndexUpdater newUpdater(IndexUpdateMode var1, CursorContext var2, boolean var3);

    public void force(FileFlushEvent var1, CursorContext var2);

    public void refresh();

    @Override
    public void close();

    public ValueIndexReader newValueReader(IndexUsageTracking var1);

    default public TokenIndexReader newTokenReader(IndexUsageTracking usageTracker) {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    default public BoundedIterable<Long> newAllEntriesValueReader(CursorContext cursorContext) {
        return this.newAllEntriesValueReader(0L, Long.MAX_VALUE, cursorContext);
    }

    public BoundedIterable<Long> newAllEntriesValueReader(long var1, long var3, CursorContext var5);

    default public BoundedIterable<EntityTokenRange> newAllEntriesTokenReader(long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    default public IndexEntriesReader[] newAllEntriesValueReader(int partitions, CursorContext cursorContext) {
        final BoundedIterable<Long> entriesReader = this.newAllEntriesValueReader(cursorContext);
        final Iterator ids = entriesReader.iterator();
        IndexEntriesReader reader = new IndexEntriesReader(){

            @Override
            public Value[] values() {
                return null;
            }

            public long next() {
                return (Long)ids.next();
            }

            public boolean hasNext() {
                return ids.hasNext();
            }

            @Override
            public void close() {
                IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{entriesReader});
            }
        };
        return new IndexEntriesReader[]{reader};
    }

    default public void validateBeforeCommit(long entityId, Value[] tuple) {
    }

    public long estimateNumberOfEntries(CursorContext var1);

    public long sizeInBytes();

    public void insertFrom(IndexAccessor var1, LongToLongFunction var2, boolean var3, IndexEntryConflictHandler var4, LongPredicate var5, int var6, JobScheduler var7, ProgressListener var8) throws IndexEntryConflictException;

    public void validate(IndexAccessor var1, boolean var2, IndexEntryConflictHandler var3, LongPredicate var4, int var5, JobScheduler var6);

    default public void maintenance() {
    }

    public static class Adapter
    implements IndexAccessor {
        @Override
        public void drop() {
        }

        @Override
        public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext, boolean parallel) {
            return SwallowingIndexUpdater.INSTANCE;
        }

        @Override
        public void force(FileFlushEvent flushEvent, CursorContext cursorContext) {
        }

        @Override
        public void refresh() {
        }

        @Override
        public void close() {
        }

        @Override
        public ValueIndexReader newValueReader(IndexUsageTracking usageTracker) {
            return ValueIndexReader.EMPTY;
        }

        @Override
        public BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
            return new BoundedIterable<Long>(this){

                public long maxCount() {
                    return 0L;
                }

                public void close() {
                }

                public Iterator<Long> iterator() {
                    return Collections.emptyIterator();
                }
            };
        }

        @Override
        public ResourceIterator<Path> snapshotFiles() {
            return Iterators.emptyResourceIterator();
        }

        public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContextFactory contextFactory, int numThreads, ProgressMonitorFactory progressMonitorFactory) {
            return true;
        }

        @Override
        public long estimateNumberOfEntries(CursorContext cursorContext) {
            return -1L;
        }

        @Override
        public long sizeInBytes() {
            return 0L;
        }

        @Override
        public void insertFrom(IndexAccessor other, LongToLongFunction entityIdConverter, boolean valueUniqueness, IndexEntryConflictHandler conflictHandler, LongPredicate entityFilter, int threads, JobScheduler jobScheduler, ProgressListener progress) throws IndexEntryConflictException {
        }

        @Override
        public void validate(IndexAccessor other, boolean valueUniqueness, IndexEntryConflictHandler conflictHandler, LongPredicate entityFilter, int threads, JobScheduler jobScheduler) {
        }
    }

    public static class Delegating
    implements IndexAccessor {
        private final IndexAccessor delegate;

        public Delegating(IndexAccessor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void drop() {
            this.delegate.drop();
        }

        @Override
        public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext, boolean parallel) {
            return this.delegate.newUpdater(mode, cursorContext, parallel);
        }

        @Override
        public void force(FileFlushEvent flushEvent, CursorContext cursorContext) {
            this.delegate.force(flushEvent, cursorContext);
        }

        @Override
        public void refresh() {
            this.delegate.refresh();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public ValueIndexReader newValueReader(IndexUsageTracking usageTracker) {
            return this.delegate.newValueReader(usageTracker);
        }

        @Override
        public TokenIndexReader newTokenReader(IndexUsageTracking usageTracker) {
            return this.delegate.newTokenReader(usageTracker);
        }

        @Override
        public BoundedIterable<Long> newAllEntriesValueReader(CursorContext cursorContext) {
            return this.delegate.newAllEntriesValueReader(cursorContext);
        }

        @Override
        public BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
            return this.delegate.newAllEntriesValueReader(fromIdInclusive, toIdExclusive, cursorContext);
        }

        @Override
        public ResourceIterator<Path> snapshotFiles() throws IOException {
            return this.delegate.snapshotFiles();
        }

        @Override
        public Map<String, Value> indexConfig() {
            return this.delegate.indexConfig();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void validateBeforeCommit(long entityId, Value[] tuple) {
            this.delegate.validateBeforeCommit(entityId, tuple);
        }

        public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContextFactory contextFactory, int numThreads, ProgressMonitorFactory progressMonitorFactory) {
            return this.delegate.consistencyCheck(reporterFactory, contextFactory, numThreads, progressMonitorFactory);
        }

        @Override
        public long estimateNumberOfEntries(CursorContext cursorContext) {
            return this.delegate.estimateNumberOfEntries(cursorContext);
        }

        @Override
        public long sizeInBytes() {
            return this.delegate.sizeInBytes();
        }

        @Override
        public void insertFrom(IndexAccessor other, LongToLongFunction entityIdConverter, boolean valueUniqueness, IndexEntryConflictHandler conflictHandler, LongPredicate entityFilter, int threads, JobScheduler jobScheduler, ProgressListener progress) throws IndexEntryConflictException {
            this.delegate.insertFrom(other, entityIdConverter, valueUniqueness, conflictHandler, entityFilter, threads, jobScheduler, progress);
        }

        @Override
        public void validate(IndexAccessor other, boolean valueUniqueness, IndexEntryConflictHandler conflictHandler, LongPredicate entityFilter, int threads, JobScheduler jobScheduler) {
            this.delegate.validate(other, valueUniqueness, conflictHandler, entityFilter, threads, jobScheduler);
        }

        @Override
        public void maintenance() {
            this.delegate.maintenance();
        }
    }
}

