/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchimport.api.input;

import java.util.Locale;

public enum ApplicationMode {
    CREATE("C"),
    UPDATE("U"),
    DELETE("D");

    private static final ApplicationMode[] MODES;
    private final String alternativeName;

    private ApplicationMode(String alternativeName) {
        this.alternativeName = alternativeName;
    }

    public static ApplicationMode valueOfLenient(String name) {
        String upperCaseName = name.toUpperCase(Locale.ROOT);
        for (ApplicationMode mode : MODES) {
            if (!upperCaseName.equals(mode.name()) && !upperCaseName.equals(mode.alternativeName)) continue;
            return mode;
        }
        throw new IllegalArgumentException("No " + ApplicationMode.class.getSimpleName() + " found by name '" + name + "'");
    }

    static {
        MODES = ApplicationMode.values();
    }
}

