/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.batchimport.api;

import java.util.function.Predicate;
import org.neo4j.function.Predicates;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.util.Preconditions;

public class IndexConfig {
    private boolean createLabelIndex;
    private boolean createRelationTypeIndex;
    private Predicate<IndexDescriptor> excludeFromPopulating = Predicates.alwaysFalse();

    public IndexConfig withLabelIndex() {
        this.createLabelIndex = true;
        return this;
    }

    public IndexConfig withRelationshipTypeIndex() {
        this.createRelationTypeIndex = true;
        return this;
    }

    public IndexConfig excludeFromPopulating(Predicate<IndexDescriptor> excludeFromPopulating) {
        this.excludeFromPopulating = (Predicate)Preconditions.requireNonNull(excludeFromPopulating, (String)"Exclude from populating predicate must not be null");
        return this;
    }

    public boolean createLabelIndex() {
        return this.createLabelIndex;
    }

    public boolean createRelationshipIndex() {
        return this.createRelationTypeIndex;
    }

    public boolean isExcludedFromPopulating(IndexDescriptor descriptor) {
        return this.excludeFromPopulating.test(descriptor);
    }

    public static IndexConfig create() {
        return new IndexConfig();
    }
}

