/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.StringSearchMode;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;

public interface GraphDatabaseService {
    public Node createNode();

    @Deprecated
    public Long createNodeId();

    public Node createNode(Label ... var1);

    public Node getNodeById(long var1);

    public Relationship getRelationshipById(long var1);

    public ResourceIterable<Node> getAllNodes();

    public ResourceIterable<Relationship> getAllRelationships();

    public ResourceIterator<Node> findNodes(Label var1, String var2, Object var3);

    default public ResourceIterator<Node> findNodes(Label label, String key1, Object value1, String key2, Object value2) {
        throw new UnsupportedOperationException("findNodes by multiple property names and values is not supported.");
    }

    default public ResourceIterator<Node> findNodes(Label label, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        throw new UnsupportedOperationException("findNodes by multiple property names and values is not supported.");
    }

    default public ResourceIterator<Node> findNodes(Label label, Map<String, Object> propertyValues) {
        throw new UnsupportedOperationException("findNodes by multiple property names and values is not supported.");
    }

    default public ResourceIterator<Node> findNodes(Label label, String key, String template, StringSearchMode searchMode) {
        throw new UnsupportedOperationException("Specialized string queries are not supported");
    }

    public Node findNode(Label var1, String var2, Object var3);

    public ResourceIterator<Node> findNodes(Label var1);

    public ResourceIterable<Label> getAllLabelsInUse();

    public ResourceIterable<RelationshipType> getAllRelationshipTypesInUse();

    public ResourceIterable<Label> getAllLabels();

    public ResourceIterable<RelationshipType> getAllRelationshipTypes();

    public ResourceIterable<String> getAllPropertyKeys();

    public boolean isAvailable(long var1);

    public void shutdown();

    public Transaction beginTx();

    public Transaction beginTx(long var1, TimeUnit var3);

    public Result execute(String var1) throws QueryExecutionException;

    public Result execute(String var1, long var2, TimeUnit var4) throws QueryExecutionException;

    public Result execute(String var1, Map<String, Object> var2) throws QueryExecutionException;

    public Result execute(String var1, Map<String, Object> var2, long var3, TimeUnit var5) throws QueryExecutionException;

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> var1);

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> var1);

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler var1);

    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler var1);

    public Schema schema();

    public IndexManager index();

    public TraversalDescription traversalDescription();

    public BidirectionalTraversalDescription bidirectionalTraversalDescription();
}

