/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlRuntimeException;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class DatabaseShutdownException
extends GqlRuntimeException
implements Status.HasStatus {
    private static final String MESSAGE = "This database is shutdown.";

    private DatabaseShutdownException(ErrorGqlStatusObject gqlStatusObject) {
        super(gqlStatusObject, MESSAGE);
    }

    private DatabaseShutdownException(ErrorGqlStatusObject gqlStatusObject, Throwable cause) {
        super(gqlStatusObject, MESSAGE, cause);
    }

    public static DatabaseShutdownException databaseUnavailable(String dbName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N09).withParam(GqlParams.StringParam.db, dbName).build();
        return new DatabaseShutdownException(gql);
    }

    public static DatabaseShutdownException databaseUnavailable(String dbName, Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N09).withParam(GqlParams.StringParam.db, dbName).build();
        return new DatabaseShutdownException(gql, cause);
    }

    public Status status() {
        return Status.General.DatabaseUnavailable;
    }
}

