/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import org.neo4j.annotations.api.PublicApi;
import org.neo4j.graphdb.traversal.GloballyUnique;
import org.neo4j.graphdb.traversal.LevelUnique;
import org.neo4j.graphdb.traversal.NotUnique;
import org.neo4j.graphdb.traversal.PathUnique;
import org.neo4j.graphdb.traversal.PrimitiveTypeFetcher;
import org.neo4j.graphdb.traversal.RecentlyUnique;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.graphdb.traversal.UniquenessFilter;

@PublicApi
public enum Uniqueness implements UniquenessFactory
{
    NODE_GLOBAL{

        @Override
        public UniquenessFilter create(Object optionalParameter) {
            Uniqueness.acceptNull(optionalParameter);
            return new GloballyUnique(PrimitiveTypeFetcher.NODE);
        }

        @Override
        public boolean eagerStartBranches() {
            return true;
        }
    }
    ,
    NODE_PATH{

        @Override
        public UniquenessFilter create(Object optionalParameter) {
            Uniqueness.acceptNull(optionalParameter);
            return new PathUnique(PrimitiveTypeFetcher.NODE);
        }

        @Override
        public boolean eagerStartBranches() {
            return true;
        }
    }
    ,
    NODE_RECENT{

        @Override
        public UniquenessFilter create(Object optionalParameter) {
            Uniqueness.acceptIntegerOrNull(optionalParameter);
            return new RecentlyUnique(PrimitiveTypeFetcher.NODE, optionalParameter);
        }

        @Override
        public boolean eagerStartBranches() {
            return true;
        }
    }
    ,
    NODE_LEVEL{

        @Override
        public UniquenessFilter create(Object optionalParameter) {
            Uniqueness.acceptNull(optionalParameter);
            return new LevelUnique(PrimitiveTypeFetcher.NODE);
        }

        @Override
        public boolean eagerStartBranches() {
            return true;
        }
    }
    ,
    RELATIONSHIP_GLOBAL{

        @Override
        public UniquenessFilter create(Object optionalParameter) {
            Uniqueness.acceptNull(optionalParameter);
            return new GloballyUnique(PrimitiveTypeFetcher.RELATIONSHIP);
        }

        @Override
        public boolean eagerStartBranches() {
            return true;
        }
    }
    ,
    RELATIONSHIP_PATH{

        @Override
        public UniquenessFilter create(Object optionalParameter) {
            Uniqueness.acceptNull(optionalParameter);
            return new PathUnique(PrimitiveTypeFetcher.RELATIONSHIP);
        }

        @Override
        public boolean eagerStartBranches() {
            return false;
        }
    }
    ,
    RELATIONSHIP_RECENT{

        @Override
        public UniquenessFilter create(Object optionalParameter) {
            Uniqueness.acceptIntegerOrNull(optionalParameter);
            return new RecentlyUnique(PrimitiveTypeFetcher.RELATIONSHIP, optionalParameter);
        }

        @Override
        public boolean eagerStartBranches() {
            return true;
        }
    }
    ,
    RELATIONSHIP_LEVEL{

        @Override
        public UniquenessFilter create(Object optionalParameter) {
            Uniqueness.acceptNull(optionalParameter);
            return new LevelUnique(PrimitiveTypeFetcher.RELATIONSHIP);
        }

        @Override
        public boolean eagerStartBranches() {
            return true;
        }
    }
    ,
    NONE{

        @Override
        public UniquenessFilter create(Object optionalParameter) {
            Uniqueness.acceptNull(optionalParameter);
            return notUniqueInstance;
        }

        @Override
        public boolean eagerStartBranches() {
            return true;
        }
    };

    private static final UniquenessFilter notUniqueInstance;

    private static void acceptNull(Object optionalParameter) {
        if (optionalParameter != null) {
            throw new IllegalArgumentException("Only accepts null parameter, was " + String.valueOf(optionalParameter));
        }
    }

    private static void acceptIntegerOrNull(Object parameter) {
        boolean isDecimalNumber;
        if (parameter == null) {
            return;
        }
        boolean bl = isDecimalNumber = parameter instanceof Number && !(parameter instanceof Float) && !(parameter instanceof Double);
        if (!isDecimalNumber) {
            throw new IllegalArgumentException("Doesn't accept non-decimal values, like '" + String.valueOf(parameter) + "'");
        }
    }

    static {
        notUniqueInstance = new NotUnique();
    }
}

