/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.exceptions.Status;

public class TransactionTerminatedHelper {
    public static TransactionTerminatedException transactionTerminated(Status status) {
        ErrorGqlStatusObject gql = TransactionTerminatedHelper.getGqlStatusObject(status, status.code().description());
        return new TransactionTerminatedException(gql, status, "");
    }

    public static TransactionTerminatedException transactionTerminated(Status status, String additionalInfo) {
        ErrorGqlStatusObject gql = TransactionTerminatedHelper.getGqlStatusObject(status, status.code().description() + " " + additionalInfo);
        return new TransactionTerminatedException(gql, status, additionalInfo);
    }

    private static ErrorGqlStatusObject getGqlStatusObject(Status status, String reason) {
        return ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)(switch (status.code().classification()) {
            case Status.Classification.ClientError -> GqlStatusInfoCodes.STATUS_25N14;
            case Status.Classification.DatabaseError -> GqlStatusInfoCodes.STATUS_25N15;
            case Status.Classification.TransientError -> GqlStatusInfoCodes.STATUS_25N16;
            default -> {
                String msg = String.format("Expected transaction termination to be caused by a ClientError, DatabaseError or TransientError but was %s", status.code().classification());
                ErrorGqlStatusObject gql = GqlHelper.get50N00((String)TransactionTerminatedException.class.getSimpleName(), (String)msg);
                throw new TransactionFailureException(gql, msg);
            }
        })).withParam(GqlParams.StringParam.msg, reason).build();
    }
}

