/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.util.List;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.kernel.api.exceptions.Status;

public class ParameterWrongTypeException
extends Neo4jException {
    public ParameterWrongTypeException(String message) {
        super(message);
    }

    public ParameterWrongTypeException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    public static ParameterWrongTypeException expectedNodeFoundInstead(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE"), (String)gotCypherType);
        return new ParameterWrongTypeException(gql, String.format("Expected to find a node but found %s instead", got));
    }

    public static ParameterWrongTypeException expectedNodeAtFoundInstead(String path, String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE"), (String)gotCypherType);
        return new ParameterWrongTypeException(gql, String.format("Expected to find a node at '%s' but found %s instead", path, got));
    }

    public static ParameterWrongTypeException expectedEntityAtRefSlotFoundInstead(int refSlot, String entity, String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of(entity.toUpperCase()), (String)gotCypherType);
        return new ParameterWrongTypeException(gql, String.format("Expected to find a %s at ref slot %s but found %s instead", entity, refSlot, got));
    }

    public static ParameterWrongTypeException expectedEntityAtLongSlotFoundInstead(int longSlot, String entity, String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of(entity.toUpperCase()), (String)gotCypherType);
        return new ParameterWrongTypeException(gql, String.format("Expected to find a %s at long slot %s but found %s instead", entity, longSlot, got));
    }

    public static ParameterWrongTypeException expectedRelFoundInstead(String got, String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE"), (String)gotCypherType);
        return new ParameterWrongTypeException(gql, String.format("Expected to find a relationship but found %s instead", got));
    }

    public static ParameterWrongTypeException expectedNodeOrRelLabels(String gotPretty, String gotCypherType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("NODE", "RELATIONSHIP"), (String)gotCypherType);
        return new ParameterWrongTypeException(gql, "Expected a node or relationship when checking types or labels.");
    }

    public Status status() {
        return Status.Statement.TypeError;
    }
}

