/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.kernel.api.exceptions.Status;

public class IndexHintException
extends Neo4jException {
    public IndexHintException(String variableName, String labelOrRelType, List<String> properties, EntityType entityType, IndexHintIndexType indexType) {
        super(IndexHintException.msg(variableName, labelOrRelType, properties, entityType, indexType));
    }

    public IndexHintException(ErrorGqlStatusObject gqlStatusObject, String variableName, String labelOrRelType, List<String> properties, EntityType entityType, IndexHintIndexType indexType) {
        super(gqlStatusObject, IndexHintException.msg(variableName, labelOrRelType, properties, entityType, indexType));
    }

    public Status status() {
        return Status.Schema.IndexNotFound;
    }

    private static String msg(String variableName, String labelOrRelType, List<String> properties, EntityType entityType, IndexHintIndexType indexType) {
        return String.format("No such index: %s", IndexHintException.indexFormatString(variableName, labelOrRelType, properties, entityType, indexType));
    }

    public static String indexFormatString(String variableName, String labelOrRelType, List<String> properties, EntityType entityType, IndexHintIndexType indexType) {
        String escapedVarName = IndexHintException.escape(variableName);
        String escapedLabelOrRelTypeName = IndexHintException.escape(labelOrRelType);
        String propertyNames = properties.stream().map(propertyName -> escapedVarName + "." + IndexHintException.escape(propertyName)).collect(Collectors.joining(", "));
        String typeString = switch (indexType) {
            case IndexHintIndexType.BTREE -> "BTREE ";
            case IndexHintIndexType.TEXT -> "TEXT ";
            case IndexHintIndexType.RANGE -> "RANGE ";
            case IndexHintIndexType.POINT -> "POINT ";
            default -> "";
        };
        return switch (entityType) {
            default -> throw new IncompatibleClassChangeError();
            case EntityType.NODE -> String.format("%sINDEX FOR (%s:%s) ON (%s)", typeString, escapedVarName, escapedLabelOrRelTypeName, propertyNames);
            case EntityType.RELATIONSHIP -> String.format("%sINDEX FOR ()-[%s:%s]-() ON (%s)", typeString, escapedVarName, escapedLabelOrRelTypeName, propertyNames);
        };
    }

    private static String escape(String str) {
        return "`" + str.replace("`", "``") + "`";
    }

    public static enum IndexHintIndexType {
        ANY,
        BTREE,
        TEXT,
        RANGE,
        POINT;

    }
}

