/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.kernel.api.exceptions.Status;

public class IndexHintException
extends Neo4jException {
    public IndexHintException(String variableName, String labelOrRelType, List<String> properties, EntityType entityType, IndexHintIndexType indexType) {
        super(IndexHintException.msg(variableName, labelOrRelType, properties, entityType, indexType));
    }

    public Status status() {
        return Status.Schema.IndexNotFound;
    }

    private static String msg(String variableName, String labelOrRelType, List<String> properties, EntityType entityType, IndexHintIndexType indexType) {
        return String.format("No such index: %s", IndexHintException.indexFormatString(variableName, labelOrRelType, properties, entityType, indexType));
    }

    public static String indexFormatString(String variableName, String labelOrRelType, List<String> properties, EntityType entityType, IndexHintIndexType indexType) {
        String indexFormatString;
        String typeString;
        String escapedVarName = IndexHintException.escape(variableName);
        String escapedLabelOrRelTypeName = IndexHintException.escape(labelOrRelType);
        String propertyNames = properties.stream().map(propertyName -> escapedVarName + "." + IndexHintException.escape(propertyName)).collect(Collectors.joining(", "));
        switch (indexType) {
            case BTREE: {
                typeString = "BTREE ";
                break;
            }
            case TEXT: {
                typeString = "TEXT ";
                break;
            }
            default: {
                typeString = "";
            }
        }
        switch (entityType) {
            case NODE: {
                indexFormatString = String.format("%sINDEX FOR (%s:%s) ON (%s)", typeString, escapedVarName, escapedLabelOrRelTypeName, propertyNames);
                break;
            }
            case RELATIONSHIP: {
                indexFormatString = String.format("%sINDEX FOR ()-[%s:%s]-() ON (%s)", typeString, escapedVarName, escapedLabelOrRelTypeName, propertyNames);
                break;
            }
            default: {
                indexFormatString = "";
            }
        }
        return indexFormatString;
    }

    private static String escape(String str) {
        return "`" + str.replace("`", "``") + "`";
    }

    public static enum IndexHintIndexType {
        ANY,
        BTREE,
        TEXT;

    }
}

