/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.messages;

import java.util.Set;
import java.util.TreeSet;

public class MessageUtil {
    private static final String CREATE_NODE_WITH_LABELS_DENIED = "Create node with labels '%s' on database '%s' is not allowed for %s.";
    private static final String WITH_USER = "user '%s' with %s";
    private static final String OVERRIDEN_MODE = "%s overridden by %s";
    private static final String RESTRICTED_MODE = "%s restricted to %s";

    public static String createNodeWithLabelsDenied(String labels, String database, String user) {
        return String.format(CREATE_NODE_WITH_LABELS_DENIED, labels, database, user);
    }

    public static String authDisabled(String mode) {
        return "AUTH_DISABLED with " + mode;
    }

    public static String withUser(String user, String mode) {
        return String.format(WITH_USER, user, mode);
    }

    public static String overridenMode(String original, String wrapping) {
        return String.format(OVERRIDEN_MODE, original, wrapping);
    }

    public static String restrictedMode(String original, String wrapping) {
        return String.format(RESTRICTED_MODE, original, wrapping);
    }

    public static String standardMode(Set<String> roles) {
        TreeSet<String> sortedRoles = new TreeSet<String>(roles);
        return roles.isEmpty() ? "no roles" : "roles " + sortedRoles;
    }
}

