/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.highlimit;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.format.highlimit.BaseHighLimitRecordFormat;
import org.neo4j.kernel.impl.store.format.highlimit.Reference;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

class RelationshipRecordFormat
extends BaseHighLimitRecordFormat<RelationshipRecord> {
    static final int RECORD_SIZE = 32;
    private static final int FIRST_IN_FIRST_CHAIN_BIT = 8;
    private static final int FIRST_IN_SECOND_CHAIN_BIT = 16;
    private static final int HAS_FIRST_CHAIN_NEXT_BIT = 32;
    private static final int HAS_SECOND_CHAIN_NEXT_BIT = 64;
    private static final int HAS_PROPERTY_BIT = 128;

    public RelationshipRecordFormat() {
        this(32);
    }

    RelationshipRecordFormat(int recordSize) {
        super(RelationshipRecordFormat.fixedRecordSize((int)recordSize), 0);
    }

    public RelationshipRecord newRecord() {
        return new RelationshipRecord(-1L);
    }

    @Override
    protected void doReadInternal(RelationshipRecord record, PageCursor cursor, int recordSize, long headerByte, boolean inUse) {
        int type = cursor.getShort() & 0xFFFF;
        long recordId = record.getId();
        record.initialize(inUse, RelationshipRecordFormat.decodeCompressedReference(cursor, headerByte, 128, NULL), RelationshipRecordFormat.decodeCompressedReference(cursor), RelationshipRecordFormat.decodeCompressedReference(cursor), type, this.decodeAbsoluteOrRelative(cursor, headerByte, 8, recordId), this.decodeAbsoluteIfPresent(cursor, headerByte, 32, recordId), this.decodeAbsoluteOrRelative(cursor, headerByte, 16, recordId), this.decodeAbsoluteIfPresent(cursor, headerByte, 64, recordId), RelationshipRecordFormat.has((long)headerByte, (int)8), RelationshipRecordFormat.has((long)headerByte, (int)16));
    }

    private long decodeAbsoluteOrRelative(PageCursor cursor, long headerByte, int firstInStartBit, long recordId) {
        return RelationshipRecordFormat.has((long)headerByte, (int)firstInStartBit) ? RelationshipRecordFormat.decodeCompressedReference(cursor) : Reference.toAbsolute(RelationshipRecordFormat.decodeCompressedReference(cursor), recordId);
    }

    @Override
    protected byte headerBits(RelationshipRecord record) {
        byte header = 0;
        header = RelationshipRecordFormat.set((byte)header, (int)8, (boolean)record.isFirstInFirstChain());
        header = RelationshipRecordFormat.set((byte)header, (int)16, (boolean)record.isFirstInSecondChain());
        header = RelationshipRecordFormat.set(header, 128, record.getNextProp(), NULL);
        header = RelationshipRecordFormat.set(header, 32, record.getFirstNextRel(), NULL);
        header = RelationshipRecordFormat.set(header, 64, record.getSecondNextRel(), NULL);
        return header;
    }

    @Override
    protected int requiredDataLength(RelationshipRecord record) {
        long recordId = record.getId();
        return 2 + RelationshipRecordFormat.length(record.getNextProp(), NULL) + RelationshipRecordFormat.length(record.getFirstNode()) + RelationshipRecordFormat.length(record.getSecondNode()) + RelationshipRecordFormat.length(this.getFirstPrevReference(record, recordId)) + this.getRelativeReferenceLength(record.getFirstNextRel(), recordId) + RelationshipRecordFormat.length(this.getSecondPrevReference(record, recordId)) + this.getRelativeReferenceLength(record.getSecondNextRel(), recordId);
    }

    @Override
    protected void doWriteInternal(RelationshipRecord record, PageCursor cursor) throws IOException {
        cursor.putShort((short)record.getType());
        long recordId = record.getId();
        RelationshipRecordFormat.encode(cursor, record.getNextProp(), NULL);
        RelationshipRecordFormat.encode(cursor, record.getFirstNode());
        RelationshipRecordFormat.encode(cursor, record.getSecondNode());
        RelationshipRecordFormat.encode(cursor, this.getFirstPrevReference(record, recordId));
        if (record.getFirstNextRel() != NULL) {
            RelationshipRecordFormat.encode(cursor, Reference.toRelative(record.getFirstNextRel(), recordId));
        }
        RelationshipRecordFormat.encode(cursor, this.getSecondPrevReference(record, recordId));
        if (record.getSecondNextRel() != NULL) {
            RelationshipRecordFormat.encode(cursor, Reference.toRelative(record.getSecondNextRel(), recordId));
        }
    }

    private long getSecondPrevReference(RelationshipRecord record, long recordId) {
        return record.isFirstInSecondChain() ? record.getSecondPrevRel() : Reference.toRelative(record.getSecondPrevRel(), recordId);
    }

    private long getFirstPrevReference(RelationshipRecord record, long recordId) {
        return record.isFirstInFirstChain() ? record.getFirstPrevRel() : Reference.toRelative(record.getFirstPrevRel(), recordId);
    }

    private int getRelativeReferenceLength(long absoluteReference, long recordId) {
        return absoluteReference != NULL ? RelationshipRecordFormat.length(Reference.toRelative(absoluteReference, recordId)) : 0;
    }

    private long decodeAbsoluteIfPresent(PageCursor cursor, long headerByte, int conditionBit, long recordId) {
        return RelationshipRecordFormat.has((long)headerByte, (int)conditionBit) ? Reference.toAbsolute(RelationshipRecordFormat.decodeCompressedReference(cursor), recordId) : NULL;
    }
}

