/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.highlimit;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.format.highlimit.BaseHighLimitRecordFormat;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;

class RelationshipGroupRecordFormat
extends BaseHighLimitRecordFormat<RelationshipGroupRecord> {
    static final int RECORD_SIZE = 32;
    private static final int HAS_OUTGOING_BIT = 8;
    private static final int HAS_INCOMING_BIT = 16;
    private static final int HAS_LOOP_BIT = 32;
    private static final int HAS_NEXT_BIT = 64;

    public RelationshipGroupRecordFormat() {
        this(32);
    }

    RelationshipGroupRecordFormat(int recordSize) {
        super(RelationshipGroupRecordFormat.fixedRecordSize((int)recordSize), 0);
    }

    public RelationshipGroupRecord newRecord() {
        return new RelationshipGroupRecord(-1L);
    }

    @Override
    protected void doReadInternal(RelationshipGroupRecord record, PageCursor cursor, int recordSize, long headerByte, boolean inUse) {
        record.initialize(inUse, cursor.getShort() & 0xFFFF, RelationshipGroupRecordFormat.decodeCompressedReference(cursor, headerByte, 8, NULL), RelationshipGroupRecordFormat.decodeCompressedReference(cursor, headerByte, 16, NULL), RelationshipGroupRecordFormat.decodeCompressedReference(cursor, headerByte, 32, NULL), RelationshipGroupRecordFormat.decodeCompressedReference(cursor), RelationshipGroupRecordFormat.decodeCompressedReference(cursor, headerByte, 64, NULL));
    }

    @Override
    protected byte headerBits(RelationshipGroupRecord record) {
        byte header = 0;
        header = RelationshipGroupRecordFormat.set(header, 8, record.getFirstOut(), NULL);
        header = RelationshipGroupRecordFormat.set(header, 16, record.getFirstIn(), NULL);
        header = RelationshipGroupRecordFormat.set(header, 32, record.getFirstLoop(), NULL);
        header = RelationshipGroupRecordFormat.set(header, 64, record.getNext(), NULL);
        return header;
    }

    @Override
    protected int requiredDataLength(RelationshipGroupRecord record) {
        return 2 + RelationshipGroupRecordFormat.length(record.getFirstOut(), NULL) + RelationshipGroupRecordFormat.length(record.getFirstIn(), NULL) + RelationshipGroupRecordFormat.length(record.getFirstLoop(), NULL) + RelationshipGroupRecordFormat.length(record.getOwningNode()) + RelationshipGroupRecordFormat.length(record.getNext(), NULL);
    }

    @Override
    protected void doWriteInternal(RelationshipGroupRecord record, PageCursor cursor) throws IOException {
        cursor.putShort((short)record.getType());
        RelationshipGroupRecordFormat.encode(cursor, record.getFirstOut(), NULL);
        RelationshipGroupRecordFormat.encode(cursor, record.getFirstIn(), NULL);
        RelationshipGroupRecordFormat.encode(cursor, record.getFirstLoop(), NULL);
        RelationshipGroupRecordFormat.encode(cursor, record.getOwningNode());
        RelationshipGroupRecordFormat.encode(cursor, record.getNext(), NULL);
    }
}

