/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.highlimit;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.format.highlimit.BaseHighLimitRecordFormat;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;

class NodeRecordFormat
extends BaseHighLimitRecordFormat<NodeRecord> {
    static final int RECORD_SIZE = 16;
    private static final long NULL_LABELS = Record.NO_LABELS_FIELD.intValue();
    private static final int DENSE_NODE_BIT = 8;
    private static final int HAS_RELATIONSHIP_BIT = 16;
    private static final int HAS_PROPERTY_BIT = 32;
    private static final int HAS_LABELS_BIT = 64;

    public NodeRecordFormat() {
        this(16);
    }

    NodeRecordFormat(int recordSize) {
        super(NodeRecordFormat.fixedRecordSize((int)recordSize), 0);
    }

    public NodeRecord newRecord() {
        return new NodeRecord(-1L);
    }

    @Override
    protected void doReadInternal(NodeRecord record, PageCursor cursor, int recordSize, long headerByte, boolean inUse) {
        boolean dense = NodeRecordFormat.has((long)headerByte, (int)8);
        long nextRel = NodeRecordFormat.decodeCompressedReference(cursor, headerByte, 16, NULL);
        long nextProp = NodeRecordFormat.decodeCompressedReference(cursor, headerByte, 32, NULL);
        long labelField = NodeRecordFormat.decodeCompressedReference(cursor, headerByte, 64, NULL_LABELS);
        record.initialize(inUse, nextProp, dense, nextRel, labelField);
    }

    @Override
    public int requiredDataLength(NodeRecord record) {
        return NodeRecordFormat.length(record.getNextRel(), NULL) + NodeRecordFormat.length(record.getNextProp(), NULL) + NodeRecordFormat.length(record.getLabelField(), NULL_LABELS);
    }

    @Override
    protected byte headerBits(NodeRecord record) {
        byte header = 0;
        header = NodeRecordFormat.set((byte)header, (int)8, (boolean)record.isDense());
        header = NodeRecordFormat.set(header, 16, record.getNextRel(), NULL);
        header = NodeRecordFormat.set(header, 32, record.getNextProp(), NULL);
        header = NodeRecordFormat.set(header, 64, record.getLabelField(), NULL_LABELS);
        return header;
    }

    @Override
    protected void doWriteInternal(NodeRecord record, PageCursor cursor) throws IOException {
        NodeRecordFormat.encode(cursor, record.getNextRel(), NULL);
        NodeRecordFormat.encode(cursor, record.getNextProp(), NULL);
        NodeRecordFormat.encode(cursor, record.getLabelField(), NULL_LABELS);
    }
}

