/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.highlimit;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.format.BaseOneByteHeaderRecordFormat;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;

class DynamicRecordFormat
extends BaseOneByteHeaderRecordFormat<DynamicRecord> {
    private static final int RECORD_HEADER_SIZE = 12;
    private static final int START_RECORD_BIT = 8;

    protected DynamicRecordFormat() {
        super(INT_STORE_HEADER_READER, 12, 1, 50);
    }

    public DynamicRecord newRecord() {
        return new DynamicRecord(-1L);
    }

    public void read(DynamicRecord record, PageCursor cursor, RecordLoad mode, int recordSize) throws IOException {
        byte headerByte = cursor.getByte();
        boolean inUse = this.isInUse(headerByte);
        if (mode.shouldLoad(inUse)) {
            int length = cursor.getShort() | cursor.getByte() << 16;
            if (length > recordSize | length < 0) {
                cursor.setCursorException(this.payloadLengthErrorMessage(record, recordSize, length));
                return;
            }
            long next = cursor.getLong();
            boolean isStartRecord = (headerByte & 8) != 0;
            record.initialize(inUse, isStartRecord, next, -1, length);
            org.neo4j.kernel.impl.store.format.standard.DynamicRecordFormat.readData((DynamicRecord)record, (PageCursor)cursor);
        } else {
            record.setInUse(inUse);
        }
    }

    private String payloadLengthErrorMessage(DynamicRecord record, int recordSize, int length) {
        return length < 0 ? this.negativePayloadErrorMessage(record, length) : org.neo4j.kernel.impl.store.format.standard.DynamicRecordFormat.payloadTooBigErrorMessage((DynamicRecord)record, (int)recordSize, (int)length);
    }

    private String negativePayloadErrorMessage(DynamicRecord record, int length) {
        return String.format("DynamicRecord[%s] claims to have a negative payload of %s bytes.", record.getId(), length);
    }

    public void write(DynamicRecord record, PageCursor cursor, int recordSize) throws IOException {
        if (record.inUse()) {
            assert (record.getLength() < 0xFFFFFF);
            byte headerByte = (byte)((record.inUse() ? 1 : 0) | (record.isStartRecord() ? 8 : 0));
            cursor.putByte(headerByte);
            cursor.putShort((short)record.getLength());
            cursor.putByte((byte)(record.getLength() >>> 16));
            cursor.putLong(record.getNextBlock());
            cursor.putBytes(record.getData());
        } else {
            this.markAsUnused(cursor);
        }
    }

    public long getNextRecordReference(DynamicRecord record) {
        return record.getNextBlock();
    }
}

