/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.enterprise;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.NodePropertyExistenceConstraintViolationKernelException;
import org.neo4j.kernel.api.exceptions.schema.RelationshipPropertyExistenceConstraintViolationKernelException;
import org.neo4j.storageengine.api.LabelItem;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

class PropertyExistenceEnforcer
extends TxStateVisitor.Delegator {
    private final StoreReadLayer storeLayer;
    private final ReadableTransactionState txState;
    private final PrimitiveIntSet labelIds = Primitive.intSet();
    private final PrimitiveIntSet propertyKeyIds = Primitive.intSet();
    private StorageStatement storageStatement;

    public PropertyExistenceEnforcer(TxStateVisitor next, ReadableTransactionState txState, StoreReadLayer storeLayer) {
        super(next);
        this.txState = txState;
        this.storeLayer = storeLayer;
    }

    public void visitNodePropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) throws ConstraintValidationKernelException {
        this.validateNode(id);
        super.visitNodePropertyChanges(id, added, changed, removed);
    }

    public void visitNodeLabelChanges(long id, Set<Integer> added, Set<Integer> removed) throws ConstraintValidationKernelException {
        this.validateNode(id);
        super.visitNodeLabelChanges(id, added, removed);
    }

    public void visitCreatedRelationship(long id, int type, long startNode, long endNode) throws ConstraintValidationKernelException {
        this.validateRelationship(id);
        super.visitCreatedRelationship(id, type, startNode, endNode);
    }

    public void visitRelPropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) throws ConstraintValidationKernelException {
        this.validateRelationship(id);
        super.visitRelPropertyChanges(id, added, changed, removed);
    }

    private void validateNode(long nodeId) throws ConstraintValidationKernelException {
        block43: {
            try (Cursor<NodeItem> node = this.nodeCursor(nodeId);){
                if (node.next()) {
                    this.labelIds.clear();
                    try (Cursor labels = ((NodeItem)node.get()).labels();){
                        while (labels.next()) {
                            this.labelIds.add(((LabelItem)labels.get()).getAsInt());
                        }
                    }
                    this.propertyKeyIds.clear();
                    Iterator constraints = this.storeLayer.constraintsGetAll();
                    while (constraints.hasNext()) {
                        PropertyConstraint constraint = (PropertyConstraint)constraints.next();
                        if (!(constraint instanceof NodePropertyExistenceConstraint) || !this.labelIds.contains(((NodePropertyExistenceConstraint)constraint).label())) continue;
                        if (this.propertyKeyIds.isEmpty()) {
                            try (Cursor properties = ((NodeItem)node.get()).properties();){
                                while (properties.next()) {
                                    this.propertyKeyIds.add(((PropertyItem)properties.get()).propertyKeyId());
                                }
                            }
                        }
                        if (this.propertyKeyIds.contains(constraint.propertyKey())) continue;
                        throw new NodePropertyExistenceConstraintViolationKernelException(((NodePropertyExistenceConstraint)constraint).label(), constraint.propertyKey(), nodeId);
                    }
                    break block43;
                }
                throw new IllegalStateException(String.format("Node %d with changes should exist.", nodeId));
            }
        }
    }

    private Cursor<NodeItem> nodeCursor(long id) {
        Cursor cursor = this.storeStatement().acquireSingleNodeCursor(id);
        return this.txState.augmentSingleNodeCursor(cursor, id);
    }

    private StorageStatement storeStatement() {
        return this.storageStatement == null ? (this.storageStatement = this.storeLayer.newStatement()) : this.storageStatement;
    }

    public void close() {
        super.close();
        if (this.storageStatement != null) {
            this.storageStatement.close();
        }
    }

    private void validateRelationship(long id) throws ConstraintValidationKernelException {
        block29: {
            try (Cursor<RelationshipItem> relationship = this.relationshipCursor(id);){
                if (relationship.next()) {
                    this.propertyKeyIds.clear();
                    Iterator constraints = this.storeLayer.constraintsGetForRelationshipType(((RelationshipItem)relationship.get()).type());
                    while (constraints.hasNext()) {
                        RelationshipPropertyConstraint constraint = (RelationshipPropertyConstraint)constraints.next();
                        if (this.propertyKeyIds.isEmpty()) {
                            try (Cursor properties = ((RelationshipItem)relationship.get()).properties();){
                                while (properties.next()) {
                                    this.propertyKeyIds.add(((PropertyItem)properties.get()).propertyKeyId());
                                }
                            }
                        }
                        if (this.propertyKeyIds.contains(constraint.propertyKey())) continue;
                        throw new RelationshipPropertyExistenceConstraintViolationKernelException(constraint.relationshipType(), constraint.propertyKey(), id);
                    }
                    break block29;
                }
                throw new IllegalStateException(String.format("Relationship %d with changes should exist.", id));
            }
        }
    }

    private Cursor<RelationshipItem> relationshipCursor(long id) {
        Cursor cursor = this.storeStatement().acquireSingleRelationshipCursor(id);
        return this.txState.augmentSingleRelationshipCursor(cursor, id);
    }
}

