/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.BitSet;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.SignpostStack;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.memory.MemoryTracker;

public interface SignpostTracking {
    public static final SignpostTracking NO_TRACKING = new SignpostTracking(){

        @Override
        public boolean isProtectedFromPruning(SignpostStack stack) {
            return false;
        }

        @Override
        public boolean canAbandonTraceBranch(SignpostStack stack) {
            return false;
        }

        @Override
        public void onPushed(TwoWaySignpost signpost, SignpostStack stack) {
        }

        @Override
        public boolean validate(SignpostStack stack) {
            return true;
        }

        @Override
        public void onPopped(TwoWaySignpost signpost, SignpostStack stack) {
        }

        @Override
        public boolean isValid(SignpostStack stack) {
            return true;
        }

        @Override
        public void clear() {
        }
    };

    public boolean isProtectedFromPruning(SignpostStack var1);

    public boolean canAbandonTraceBranch(SignpostStack var1);

    public void onPushed(TwoWaySignpost var1, SignpostStack var2);

    public void onPopped(TwoWaySignpost var1, SignpostStack var2);

    public boolean validate(SignpostStack var1);

    public boolean isValid(SignpostStack var1);

    public void clear();

    public static SignpostTracking trailMode(MemoryTracker memoryTracker, PPBFSHooks hooks) {
        return new TrailModeSignPostTracking(memoryTracker, hooks);
    }

    public static SignpostTracking walkMode() {
        return NO_TRACKING;
    }

    public static final class TrailModeSignPostTracking
    implements SignpostTracking {
        private final HeapTrackingLongObjectHashMap<BitSet> relationshipPresenceAtDepth;
        private final BitSet targetTrails;
        private final BitSet protectFromPruning;
        private final PPBFSHooks hooks;

        TrailModeSignPostTracking(MemoryTracker memoryTracker, PPBFSHooks hooks) {
            this.relationshipPresenceAtDepth = HeapTrackingLongObjectHashMap.createLongObjectHashMap((MemoryTracker)memoryTracker);
            this.targetTrails = new BitSet();
            this.targetTrails.set(0);
            this.protectFromPruning = new BitSet();
            this.hooks = hooks;
        }

        @Override
        public boolean isProtectedFromPruning(SignpostStack stack) {
            return this.protectFromPruning.get(stack.size());
        }

        @Override
        public boolean canAbandonTraceBranch(SignpostStack stack) {
            int dup = this.distanceToDuplicate(stack.headSignpost());
            if (dup == 0) {
                return false;
            }
            int sourceLength = stack.lengthFromSource();
            for (int i = 0; i <= dup; ++i) {
                TwoWaySignpost candidate = stack.signpost(stack.size() - 1 - i);
                if (!candidate.prevNode.validatedAtLength(sourceLength)) {
                    return false;
                }
                sourceLength += candidate.dataGraphLength();
            }
            this.protectFromPruning.set(stack.size() - 1 - dup, stack.size() - 1, true);
            return true;
        }

        @Override
        public void onPushed(TwoWaySignpost signpost, SignpostStack stack) {
            int size = stack.size();
            this.protectFromPruning.set(size - 1, false);
            this.targetTrails.set(size, this.targetTrails.get(size - 1) && this.distanceToDuplicate(stack.headSignpost()) == 0);
            if (signpost instanceof TwoWaySignpost.RelSignpost) {
                TwoWaySignpost.RelSignpost rel = (TwoWaySignpost.RelSignpost)signpost;
                BitSet depths = (BitSet)this.relationshipPresenceAtDepth.get(rel.relId);
                if (depths == null) {
                    depths = new BitSet();
                    this.relationshipPresenceAtDepth.put(rel.relId, (Object)depths);
                }
                depths.set(size - 1);
            } else if (signpost instanceof TwoWaySignpost.MultiRelSignpost) {
                TwoWaySignpost.MultiRelSignpost multiRel = (TwoWaySignpost.MultiRelSignpost)signpost;
                for (long relId : multiRel.rels) {
                    BitSet depths = (BitSet)this.relationshipPresenceAtDepth.get(relId);
                    if (depths == null) {
                        depths = new BitSet();
                        this.relationshipPresenceAtDepth.put(relId, (Object)depths);
                    }
                    depths.set(size - 1);
                }
            }
        }

        @Override
        public boolean validate(SignpostStack stack) {
            int sourceLength = 0;
            for (int i = stack.size() - 1; i >= 0; --i) {
                TwoWaySignpost signpost = stack.signpost(i);
                sourceLength += signpost.dataGraphLength();
                if (signpost instanceof TwoWaySignpost.RelSignpost) {
                    TwoWaySignpost.RelSignpost rel = (TwoWaySignpost.RelSignpost)signpost;
                    BitSet bitset = (BitSet)this.relationshipPresenceAtDepth.get(rel.relId);
                    assert (bitset.get(i));
                    if (bitset.length() > i + 1) {
                        this.hooks.invalidTrail(stack);
                        return false;
                    }
                } else if (signpost instanceof TwoWaySignpost.MultiRelSignpost) {
                    TwoWaySignpost.MultiRelSignpost rels = (TwoWaySignpost.MultiRelSignpost)signpost;
                    for (int j = 0; j < rels.rels.length; ++j) {
                        long relId = rels.rels[j];
                        BitSet bitset = (BitSet)this.relationshipPresenceAtDepth.get(relId);
                        assert (bitset.get(i));
                        if (bitset.length() <= i + 1) continue;
                        this.hooks.invalidTrail(stack);
                        return false;
                    }
                }
                if (signpost.isValidatedAtLength(sourceLength)) continue;
                signpost.validate(sourceLength);
                if (signpost.forwardNode.validatedAtLength(sourceLength)) continue;
                signpost.forwardNode.setValidatedAtLength(sourceLength, stack.dgLength() - sourceLength);
            }
            return true;
        }

        @Override
        public void onPopped(TwoWaySignpost signpost, SignpostStack stack) {
            if (signpost instanceof TwoWaySignpost.RelSignpost) {
                TwoWaySignpost.RelSignpost rel = (TwoWaySignpost.RelSignpost)signpost;
                BitSet depths = (BitSet)this.relationshipPresenceAtDepth.get(rel.relId);
                depths.clear(stack.size());
                if (depths.isEmpty()) {
                    this.relationshipPresenceAtDepth.remove(rel.relId);
                }
            } else if (signpost instanceof TwoWaySignpost.MultiRelSignpost) {
                TwoWaySignpost.MultiRelSignpost relsSignpost = (TwoWaySignpost.MultiRelSignpost)signpost;
                for (long relId : relsSignpost.rels) {
                    BitSet depths = (BitSet)this.relationshipPresenceAtDepth.get(relId);
                    depths.clear(stack.size());
                    if (!depths.isEmpty()) continue;
                    this.relationshipPresenceAtDepth.remove(relId);
                }
            }
        }

        private int distanceToDuplicate(TwoWaySignpost signpost) {
            if (signpost instanceof TwoWaySignpost.RelSignpost) {
                TwoWaySignpost.RelSignpost rel = (TwoWaySignpost.RelSignpost)signpost;
                BitSet stack = (BitSet)this.relationshipPresenceAtDepth.get(rel.relId);
                if (stack == null) {
                    return 0;
                }
                int last = stack.length();
                if (last == 0) {
                    return 0;
                }
                int next = stack.previousSetBit(last - 2);
                if (next == -1) {
                    return 0;
                }
                return last - 1 - next;
            }
            if (signpost instanceof TwoWaySignpost.MultiRelSignpost) {
                TwoWaySignpost.MultiRelSignpost rels = (TwoWaySignpost.MultiRelSignpost)signpost;
                int min = 0;
                for (long relId : rels.rels) {
                    int next;
                    int last;
                    BitSet stack = (BitSet)this.relationshipPresenceAtDepth.get(relId);
                    if (stack == null || (last = stack.length()) == 0 || (next = stack.previousSetBit(last - 2)) == -1) continue;
                    int value = last - 1 - next;
                    min = min == 0 ? value : Math.min(min, value);
                }
                return min;
            }
            return 0;
        }

        @Override
        public boolean isValid(SignpostStack stack) {
            return this.targetTrails.get(stack.size());
        }

        @Override
        public void clear() {
            this.relationshipPresenceAtDepth.clear();
        }
    }
}

