/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.BFSExpander;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.FoundNodes;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.GlobalState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PathTracer;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.Propagator;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.SearchMode;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.SignpostStack;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TargetTracker;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TraversalDirection;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TraversalMatchModeFactory;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.ProductGraphTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public final class PGPathPropagatingBFS<Row>
extends PrefetchingIterator<Row>
implements AutoCloseable {
    private final GlobalState globalState;
    private final BFSExpander bfsExpander;
    private final NodeState sourceNodeState;
    private final long intoTarget;
    private final State finalState;
    private final SearchMode searchMode;
    private final PathTracer<Row> pathTracer;
    private final Function<SignpostStack, Row> toRow;
    private final Predicate<Row> nonInlinedPredicate;
    private final boolean isGroupSelector;
    private final int maxDepth;
    private final MemoryTracker memoryTracker;
    private final PPBFSHooks hooks;
    private final AssertOpen assertOpen;
    private final Propagator propagator;
    private final FoundNodes foundNodes;
    private final TargetTracker targets;
    private Iterator<NodeState> currentTargets = Collections.emptyIterator();
    private boolean targetSaturated = false;
    private boolean groupYielded = false;

    public PGPathPropagatingBFS(long source, State startState, long intoTarget, State finalState, SearchMode searchMode, ProductGraphTraversalCursor.DataGraphRelationshipCursor graphCursor, PathTracer<Row> pathTracer, Function<SignpostStack, Row> toRow, Predicate<Row> nonInlinedPredicate, boolean isGroupSelector, int maxDepth, int initialCountForTargetNodes, int nfaStateCount, MemoryTracker mt, PPBFSHooks hooks, AssertOpen assertOpen, TraversalMatchModeFactory tracker) {
        Preconditions.checkArgument((intoTarget != -1L || searchMode == SearchMode.Unidirectional ? 1 : 0) != 0, (String)"Bidirectional search can only be performed with a target node");
        this.intoTarget = intoTarget;
        this.finalState = finalState;
        this.searchMode = searchMode;
        this.pathTracer = pathTracer;
        this.toRow = toRow;
        this.nonInlinedPredicate = nonInlinedPredicate;
        this.isGroupSelector = isGroupSelector;
        this.maxDepth = maxDepth;
        this.memoryTracker = mt.getScopedMemoryTracker();
        this.hooks = hooks;
        this.assertOpen = assertOpen;
        this.foundNodes = new FoundNodes(this.memoryTracker, searchMode, nfaStateCount);
        this.targets = new TargetTracker(this.memoryTracker, hooks);
        this.propagator = new Propagator(this.memoryTracker, hooks);
        this.globalState = new GlobalState(this.propagator, this.targets, searchMode, this.memoryTracker, hooks, initialCountForTargetNodes);
        ProductGraphTraversalCursor cursor = new ProductGraphTraversalCursor(graphCursor, this.memoryTracker);
        this.bfsExpander = new BFSExpander(this.foundNodes, this.globalState, cursor, graphCursor, intoTarget, nfaStateCount, tracker);
        this.sourceNodeState = new NodeState(this.globalState, source, startState, intoTarget, tracker.lengths());
        pathTracer.reset();
        this.hooks.newRow(source);
    }

    public static <Row> PGPathPropagatingBFS<Row> create(long source, State startState, long intoTarget, State finalState, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, PathTracer<Row> pathTracer, Function<SignpostStack, Row> toRow, Predicate<Row> nonInlinedPredicate, boolean isGroupSelector, int maxDepth, int initialCountForTargetNodes, int numberOfNfaStates, MemoryTracker mt, PPBFSHooks hooks, AssertOpen assertOpen, TraversalMatchModeFactory tracker) {
        return new PGPathPropagatingBFS<Row>(source, startState, intoTarget, finalState, intoTarget == -1L ? SearchMode.Unidirectional : SearchMode.Bidirectional, new ProductGraphTraversalCursor.DataGraphRelationshipCursorImpl(read, nodeCursor, relCursor, hooks), pathTracer, toRow, nonInlinedPredicate, isGroupSelector, maxDepth, initialCountForTargetNodes, numberOfNfaStates, mt, hooks, assertOpen, tracker);
    }

    protected Row fetchNextOrNull() {
        if (this.targetSaturated) {
            return null;
        }
        while (true) {
            if (this.pathTracer.ready()) {
                while (this.pathTracer.hasNext()) {
                    Object row = this.pathTracer.next();
                    if (!this.nonInlinedPredicate.test(row)) continue;
                    if (this.isGroupSelector) {
                        this.groupYielded = true;
                    } else {
                        this.pathTracer.decrementTargetCount();
                    }
                    if (this.intoTarget != -1L && this.pathTracer.isSaturated()) {
                        this.targetSaturated = true;
                        this.hooks.finished();
                    }
                    return (Row)row;
                }
            }
            if (this.groupYielded) {
                this.groupYielded = false;
                this.pathTracer.decrementTargetCount();
                if (this.intoTarget != -1L && this.pathTracer.isSaturated()) {
                    this.targetSaturated = true;
                    this.hooks.finished();
                    return null;
                }
            }
            if (!this.currentTargets.hasNext()) {
                if (this.nextLevelWithTargets()) {
                    this.hooks.trace(this.globalState.depth());
                    this.currentTargets = this.targets.iterate();
                } else {
                    this.targetSaturated = true;
                    this.hooks.finished();
                    return null;
                }
            }
            this.pathTracer.reset();
            this.pathTracer.initialize(this.toRow, this.sourceNodeState, this.currentTargets.next(), this.globalState.depth());
        }
    }

    private boolean nextLevelWithTargets() {
        if (this.initialLevel()) {
            return true;
        }
        do {
            if (this.shouldQuit()) {
                return false;
            }
            if (this.nextLevel()) continue;
            return false;
        } while (!this.targets.hasTargets());
        return true;
    }

    private boolean shouldQuit() {
        return this.targets.allKnownTargetsSaturated() && !this.foundNodes.hasMore();
    }

    private boolean nextLevel() {
        this.assertOpen.assertOpen();
        if (this.maxDepth != -1 && this.globalState.depth() == this.maxDepth) {
            return false;
        }
        this.globalState.nextDepth();
        this.hooks.nextLevel(this.globalState.depth());
        this.targets.clear();
        if (this.foundNodes.hasMore()) {
            this.bfsExpander.expand();
        } else if (!this.propagator.hasScheduled()) {
            return false;
        }
        this.propagator.propagate(this.globalState.depth());
        return true;
    }

    private boolean initialLevel() {
        if (this.foundNodes.totalDepth() > 0) {
            return false;
        }
        this.hooks.nextLevel(0);
        this.foundNodes.openBuffer();
        this.bfsExpander.discover(this.sourceNodeState, TraversalDirection.FORWARD);
        if (this.sourceNodeState.isTarget()) {
            this.targets.addTarget(this.sourceNodeState);
        }
        this.foundNodes.commitBuffer(TraversalDirection.FORWARD);
        if (this.searchMode == SearchMode.Bidirectional) {
            this.foundNodes.openBuffer();
            this.bfsExpander.encounter(this.intoTarget, this.finalState, TraversalDirection.BACKWARD);
            this.foundNodes.commitBuffer(TraversalDirection.BACKWARD);
        }
        return this.targets.hasCurrentUnsaturatedTargets();
    }

    public void setTracer(KernelReadTracer tracer) {
        this.bfsExpander.setTracer(tracer);
    }

    @Override
    public void close() throws Exception {
        this.foundNodes.close();
        this.bfsExpander.close();
        this.targets.close();
        this.propagator.close();
        this.memoryTracker.close();
    }

    public static enum Phase {
        Expansion,
        Propagation,
        Tracing;

    }
}

