/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.Arrays;
import java.util.Objects;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.helpers.traversal.SlotOrName;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.Lengths;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PGPathPropagatingBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PathWriter;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.MultiRelationshipExpansion;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.RelationshipExpansion;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TwoWaySignpost
implements Measurable {
    public static final int NO_TARGET_DISTANCE = -1;
    public final NodeState prevNode;
    public final NodeState forwardNode;
    protected final Lengths lengths;
    protected int minTargetDistance = -1;

    protected TwoWaySignpost(NodeState prevNode, NodeState forwardNode) {
        this.prevNode = prevNode;
        this.forwardNode = forwardNode;
        this.lengths = new Lengths();
    }

    protected TwoWaySignpost(NodeState prevNode, NodeState forwardNode, int sourceLength) {
        this(prevNode, forwardNode);
        this.lengths.set(sourceLength, Lengths.Type.Source);
    }

    public static RelSignpost fromRelExpansion(MemoryTracker mt, NodeState prevNode, long relId, NodeState forwardNode, RelationshipExpansion relationshipExpansion, int sourceLength) {
        return TwoWaySignpost.allocate(mt, new RelSignpost(prevNode, relId, forwardNode, relationshipExpansion, sourceLength));
    }

    public static RelSignpost fromRelExpansion(MemoryTracker mt, NodeState prevNode, long relId, NodeState forwardNode, RelationshipExpansion relationshipExpansion) {
        return TwoWaySignpost.allocate(mt, new RelSignpost(prevNode, relId, forwardNode, relationshipExpansion));
    }

    public static NodeSignpost fromNodeJuxtaposition(MemoryTracker mt, NodeState prevNode, NodeState forwardNode, int sourceLength) {
        return TwoWaySignpost.allocate(mt, new NodeSignpost(prevNode, forwardNode, sourceLength));
    }

    public static NodeSignpost fromNodeJuxtaposition(MemoryTracker mt, NodeState prevNode, NodeState forwardNode) {
        return TwoWaySignpost.allocate(mt, new NodeSignpost(prevNode, forwardNode));
    }

    public static MultiRelSignpost fromMultiRel(MemoryTracker mt, NodeState prevNode, long[] rels, long[] nodes, MultiRelationshipExpansion expansion, NodeState forwardNode) {
        return TwoWaySignpost.allocate(mt, new MultiRelSignpost(prevNode, rels, nodes, forwardNode, expansion));
    }

    public static MultiRelSignpost fromMultiRel(MemoryTracker mt, NodeState prevNode, long[] rels, long[] nodes, MultiRelationshipExpansion expansion, NodeState forwardNode, int sourceLength) {
        return TwoWaySignpost.allocate(mt, new MultiRelSignpost(prevNode, rels, nodes, forwardNode, expansion, sourceLength));
    }

    private static <T extends TwoWaySignpost> T allocate(MemoryTracker mt, T signpost) {
        mt.allocateHeap(signpost.estimatedHeapUsage());
        return signpost;
    }

    public abstract int entityCount();

    public abstract int dataGraphLength();

    public abstract void materialize(PathWriter var1);

    public boolean hasBeenTraced() {
        return this.minTargetDistance != -1;
    }

    public void setMinTargetDistance(int distance, PGPathPropagatingBFS.Phase phase) {
        Preconditions.checkState((this.minTargetDistance == -1 ? 1 : 0) != 0, (String)"A signpost should only have setMinDistToTarget() called upon it on the first trace");
        this.minTargetDistance = distance;
        this.prevNode.addTargetSignpost(this, distance, phase);
    }

    public int minTargetDistance() {
        return this.minTargetDistance;
    }

    public void addSourceLength(int sourceLength) {
        this.lengths.set(sourceLength, Lengths.Type.Source);
        this.prevNode.globalState.hooks.addSourceLength(this, sourceLength);
    }

    public boolean hasSourceLength(int sourceLength) {
        return this.lengths.get(sourceLength, Lengths.Type.Source);
    }

    public void propagate(int sourceLength, int targetLength) {
        int newLength = sourceLength + this.dataGraphLength();
        this.forwardNode.newPropagatedSourceLength(newLength, targetLength - this.dataGraphLength());
        this.addSourceLength(newLength);
    }

    public void pruneSourceLength(int sourceLength) {
        this.prevNode.globalState.hooks.pruneSourceLength(this, sourceLength);
        this.lengths.clear(sourceLength, Lengths.Type.Source);
        this.forwardNode.synchronizeLengthAfterPrune(sourceLength);
    }

    public void setVerified(int sourceLength) {
        this.prevNode.globalState.hooks.setVerified(this, sourceLength);
        this.lengths.set(sourceLength, Lengths.Type.ConfirmedSource);
    }

    public boolean isVerifiedAtLength(int sourceLength) {
        return this.lengths.get(sourceLength, Lengths.Type.ConfirmedSource);
    }

    public static final class RelSignpost
    extends TwoWaySignpost {
        public final long relId;
        public final RelationshipExpansion relationshipExpansion;
        private static long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RelSignpost.class);

        private RelSignpost(NodeState prevNode, long relId, NodeState forwardNode, RelationshipExpansion relationshipExpansion, int lengthFromSource) {
            super(prevNode, forwardNode, lengthFromSource);
            this.relId = relId;
            this.relationshipExpansion = relationshipExpansion;
        }

        private RelSignpost(NodeState prevNode, long relId, NodeState forwardNode, RelationshipExpansion relationshipExpansion) {
            super(prevNode, forwardNode);
            this.relId = relId;
            this.relationshipExpansion = relationshipExpansion;
        }

        @Override
        public void materialize(PathWriter pathWriter) {
            pathWriter.writeNode(this.prevNode.state().slotOrName(), this.prevNode.id());
            pathWriter.writeRel(this.relationshipExpansion.slotOrName(), this.relId);
        }

        @Override
        public int entityCount() {
            return 2;
        }

        @Override
        public int dataGraphLength() {
            return 1;
        }

        public String toString() {
            String sourceLengths;
            StringBuilder sb = new StringBuilder("RE ").append(this.prevNode).append("-[");
            if (this.relationshipExpansion.slotOrName() != SlotOrName.none()) {
                sb.append(this.relationshipExpansion.slotOrName()).append("@");
            }
            sb.append(this.relId).append("]->").append(this.forwardNode);
            if (this.minTargetDistance != -1) {
                sb.append(", minTargetDistance: ").append(this.minTargetDistance);
            }
            if (!(sourceLengths = this.lengths.renderSourceLengths()).isEmpty()) {
                sb.append(", sourceLengths: ").append(sourceLengths);
            }
            return sb.toString();
        }

        public long estimatedHeapUsage() {
            return SHALLOW_SIZE + Lengths.SHALLOW_SIZE;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelSignpost that = (RelSignpost)o;
            return this.prevNode == that.prevNode && this.forwardNode == that.forwardNode && this.relId == that.relId;
        }

        public int hashCode() {
            return Objects.hash(this.prevNode, this.forwardNode, this.relId);
        }
    }

    public static final class NodeSignpost
    extends TwoWaySignpost {
        private static long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeSignpost.class);

        private NodeSignpost(NodeState prevNode, NodeState forwardNode, int lengthFromSource) {
            super(prevNode, forwardNode, lengthFromSource);
            assert (prevNode != forwardNode) : "A state cannot have a node juxtaposition to itself";
        }

        @Override
        public void materialize(PathWriter pathWriter) {
            pathWriter.writeNode(this.prevNode.state().slotOrName(), this.prevNode.id());
        }

        @Override
        public int entityCount() {
            return 1;
        }

        private NodeSignpost(NodeState prevNode, NodeState forwardNode) {
            super(prevNode, forwardNode);
            assert (prevNode != forwardNode) : "A state cannot have a node juxtaposition to itself";
        }

        @Override
        public int dataGraphLength() {
            return 0;
        }

        public String toString() {
            String sourceLengths;
            StringBuilder sb = new StringBuilder("NJ ").append(this.prevNode).append(" ").append(this.forwardNode);
            if (this.minTargetDistance != -1) {
                sb.append(", minTargetDistance: ").append(this.minTargetDistance);
            }
            if (!(sourceLengths = this.lengths.renderSourceLengths()).isEmpty()) {
                sb.append(", sourceLengths: ").append(sourceLengths);
            }
            return sb.toString();
        }

        public long estimatedHeapUsage() {
            return SHALLOW_SIZE + Lengths.SHALLOW_SIZE;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeSignpost that = (NodeSignpost)o;
            return this.prevNode == that.prevNode && this.forwardNode == that.forwardNode;
        }

        public int hashCode() {
            return Objects.hash(this.prevNode, this.forwardNode);
        }
    }

    public static final class MultiRelSignpost
    extends TwoWaySignpost {
        public final long[] rels;
        public final long[] nodes;
        public final MultiRelationshipExpansion transition;
        private static long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(MultiRelSignpost.class);

        private MultiRelSignpost(NodeState prevNode, long[] rels, long[] nodes, NodeState forwardNode, MultiRelationshipExpansion transition, int lengthFromSource) {
            super(prevNode, forwardNode, lengthFromSource);
            this.rels = rels;
            this.nodes = nodes;
            this.transition = transition;
            assert (rels.length == transition.rels().length);
            assert (nodes.length == transition.nodes().length);
        }

        @Override
        public void materialize(PathWriter pathWriter) {
            pathWriter.writeNode(this.prevNode.state().slotOrName(), this.prevNode.id());
            for (int i = 0; i < this.nodes.length; ++i) {
                long rel = this.rels[i];
                SlotOrName relSlot = this.transition.rels()[i].slotOrName();
                pathWriter.writeRel(relSlot, rel);
                long node = this.nodes[i];
                SlotOrName nodeSlot = this.transition.nodes()[i].slotOrName();
                pathWriter.writeNode(nodeSlot, node);
            }
            long lastRel = this.rels[this.rels.length - 1];
            SlotOrName lastSlot = this.transition.rels()[this.transition.rels().length - 1].slotOrName();
            pathWriter.writeRel(lastSlot, lastRel);
        }

        private MultiRelSignpost(NodeState prevNode, long[] rels, long[] nodes, NodeState forwardNode, MultiRelationshipExpansion transition) {
            super(prevNode, forwardNode);
            this.rels = rels;
            this.nodes = nodes;
            this.transition = transition;
            assert (rels.length == transition.rels().length);
            assert (nodes.length == transition.nodes().length);
        }

        public long estimatedHeapUsage() {
            return SHALLOW_SIZE + Lengths.SHALLOW_SIZE + HeapEstimator.sizeOf((long[])this.rels) + HeapEstimator.sizeOf((long[])this.nodes);
        }

        @Override
        public int entityCount() {
            return 1 + this.rels.length + this.nodes.length;
        }

        @Override
        public int dataGraphLength() {
            return this.transition.length();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiRelSignpost that = (MultiRelSignpost)o;
            return this.prevNode == that.prevNode && this.forwardNode == that.forwardNode && Arrays.equals(this.rels, that.rels);
        }

        public int hashCode() {
            return Objects.hash(this.prevNode, this.forwardNode, Arrays.hashCode(this.rels));
        }

        public String toString() {
            String sourceLengths;
            StringBuilder sb = new StringBuilder("MRE ").append(this.prevNode);
            if (this.transition.rels()[0].direction() == Direction.INCOMING) {
                sb.append("<");
            }
            sb.append("-[");
            for (int i = 0; i < this.transition.length(); ++i) {
                MultiRelationshipExpansion.Rel rel = this.transition.rels()[i];
                if (rel.slotOrName() != SlotOrName.none()) {
                    sb.append(rel.slotOrName()).append("@");
                }
                sb.append(this.rels[i]).append("]-");
                if (rel.direction() == Direction.OUTGOING) {
                    sb.append(">");
                }
                if (i >= this.nodes.length) continue;
                sb.append("(");
                MultiRelationshipExpansion.Node node = this.transition.nodes()[i];
                if (node.slotOrName() != SlotOrName.none()) {
                    sb.append(node.slotOrName()).append("@");
                }
                sb.append(this.nodes[i]).append(")");
                if (this.transition.rels()[i + 1].direction() == Direction.INCOMING) {
                    sb.append("<");
                }
                sb.append("-[");
            }
            sb.append(this.forwardNode);
            if (this.minTargetDistance != -1) {
                sb.append(", minTargetDistance: ").append(this.minTargetDistance);
            }
            if (!(sourceLengths = this.lengths.renderSourceLengths()).isEmpty()) {
                sb.append(", sourceLengths: ").append(sourceLengths);
            }
            return sb.toString();
        }
    }
}

