/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.BitSet;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingIntArrayList;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PathWriter;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.memory.MemoryTracker;

public class SignpostStack {
    private final HeapTrackingArrayList<TwoWaySignpost> activeSignposts;
    private int entityCount = 0;
    private final HeapTrackingIntArrayList nodeSourceSignpostIndices;
    private final BitSet targetTrails;
    private final PPBFSHooks hooks;
    private NodeState targetNode = null;
    private int dgLength = -1;
    private int dgLengthToTarget = -1;
    public final HeapTrackingLongObjectHashMap<BitSet> relationshipPresenceAtDepth;

    SignpostStack(MemoryTracker memoryTracker, PPBFSHooks hooks) {
        this.activeSignposts = HeapTrackingArrayList.newArrayList((MemoryTracker)memoryTracker);
        this.nodeSourceSignpostIndices = HeapTrackingIntArrayList.newIntArrayList((MemoryTracker)memoryTracker);
        this.relationshipPresenceAtDepth = HeapTrackingLongObjectHashMap.createLongObjectHashMap((MemoryTracker)memoryTracker);
        this.targetTrails = new BitSet();
        this.targetTrails.set(0);
        this.hooks = hooks;
        this.nodeSourceSignpostIndices.add(-1);
    }

    public boolean hasNext() {
        return this.nodeSourceSignpostIndices.notEmpty();
    }

    public void reset() {
        this.targetNode = null;
        this.relationshipPresenceAtDepth.clear();
        this.activeSignposts.clear();
        this.entityCount = 0;
        this.nodeSourceSignpostIndices.clear();
        this.dgLength = -1;
        this.dgLengthToTarget = -1;
    }

    public void initialize(NodeState targetNode, int dgLength) {
        this.targetNode = targetNode;
        this.dgLength = dgLength;
        this.nodeSourceSignpostIndices.add(-1);
        this.dgLengthToTarget = 0;
    }

    public TwoWaySignpost headSignpost() {
        return (TwoWaySignpost)this.activeSignposts.last();
    }

    public NodeState headNode() {
        return this.activeSignposts.isEmpty() ? this.targetNode : ((TwoWaySignpost)this.activeSignposts.last()).prevNode;
    }

    public NodeState target() {
        return this.targetNode;
    }

    public int size() {
        return this.activeSignposts.size();
    }

    public TwoWaySignpost signpost(int index) {
        return (TwoWaySignpost)this.activeSignposts.get(index);
    }

    public NodeState node(int index) {
        return index == 0 ? this.targetNode : this.signpost((int)(index - 1)).prevNode;
    }

    public int lengthToTarget() {
        return this.dgLengthToTarget;
    }

    public int lengthFromSource() {
        return this.dgLength - this.dgLengthToTarget;
    }

    public void materialize(PathWriter writer) {
        for (int i = this.activeSignposts.size() - 1; i >= 0; --i) {
            TwoWaySignpost signpost = (TwoWaySignpost)this.activeSignposts.get(i);
            signpost.materialize(writer);
        }
        writer.writeNode(this.targetNode.state().slotOrName(), this.targetNode.id());
    }

    public boolean pushNext() {
        int currentIndex;
        NodeState current = this.headNode();
        int nextIndex = current.nextSignpostIndexForLength(currentIndex = this.nodeSourceSignpostIndices.last(), this.lengthFromSource());
        if (nextIndex == -1) {
            return false;
        }
        TwoWaySignpost signpost = current.getSourceSignpost(nextIndex);
        this.activeSignposts.add((Object)signpost);
        this.entityCount += signpost.entityCount();
        this.targetTrails.set(this.size(), this.targetTrails.get(this.size() - 1) && this.distanceToDuplicate() == 0);
        this.dgLengthToTarget += signpost.dataGraphLength();
        this.nodeSourceSignpostIndices.set(this.nodeSourceSignpostIndices.size() - 1, nextIndex);
        this.nodeSourceSignpostIndices.add(-1);
        if (signpost instanceof TwoWaySignpost.RelSignpost) {
            TwoWaySignpost.RelSignpost rel = (TwoWaySignpost.RelSignpost)signpost;
            BitSet depths = (BitSet)this.relationshipPresenceAtDepth.get(rel.relId);
            if (depths == null) {
                depths = new BitSet();
                this.relationshipPresenceAtDepth.put(rel.relId, (Object)depths);
            }
            depths.set(this.size() - 1);
        } else if (signpost instanceof TwoWaySignpost.MultiRelSignpost) {
            TwoWaySignpost.MultiRelSignpost multiRel = (TwoWaySignpost.MultiRelSignpost)signpost;
            for (long relId : multiRel.rels) {
                BitSet depths = (BitSet)this.relationshipPresenceAtDepth.get(relId);
                if (depths == null) {
                    depths = new BitSet();
                    this.relationshipPresenceAtDepth.put(relId, (Object)depths);
                }
                depths.set(this.size() - 1);
            }
        }
        this.hooks.activateSignpost(this.lengthFromSource(), signpost);
        return true;
    }

    public int distanceToDuplicate() {
        Object stack;
        TwoWaySignpost twoWaySignpost = this.headSignpost();
        if (twoWaySignpost instanceof TwoWaySignpost.RelSignpost) {
            TwoWaySignpost.RelSignpost rel = (TwoWaySignpost.RelSignpost)twoWaySignpost;
            stack = (BitSet)this.relationshipPresenceAtDepth.get(rel.relId);
            if (stack == null) {
                return 0;
            }
            int last = ((BitSet)stack).length();
            if (last == 0) {
                return 0;
            }
            int next = ((BitSet)stack).previousSetBit(last - 2);
            if (next == -1) {
                return 0;
            }
            return last - 1 - next;
        }
        stack = this.headSignpost();
        if (stack instanceof TwoWaySignpost.MultiRelSignpost) {
            TwoWaySignpost.MultiRelSignpost rels = (TwoWaySignpost.MultiRelSignpost)stack;
            int min = 0;
            for (long relId : rels.rels) {
                int next;
                int last;
                BitSet stack2 = (BitSet)this.relationshipPresenceAtDepth.get(relId);
                if (stack2 == null || (last = stack2.length()) == 0 || (next = stack2.previousSetBit(last - 2)) == -1) continue;
                int value = last - 1 - next;
                min = min == 0 ? value : Math.min(min, value);
            }
            return min;
        }
        return 0;
    }

    public TwoWaySignpost pop() {
        this.nodeSourceSignpostIndices.removeLast();
        if (this.activeSignposts.isEmpty()) {
            return null;
        }
        TwoWaySignpost signpost = (TwoWaySignpost)this.activeSignposts.removeLast();
        this.entityCount -= signpost.entityCount();
        this.dgLengthToTarget -= signpost.dataGraphLength();
        if (signpost instanceof TwoWaySignpost.RelSignpost) {
            TwoWaySignpost.RelSignpost rel = (TwoWaySignpost.RelSignpost)signpost;
            BitSet depths = (BitSet)this.relationshipPresenceAtDepth.get(rel.relId);
            depths.clear(this.size());
            if (depths.isEmpty()) {
                this.relationshipPresenceAtDepth.remove(rel.relId);
            }
        } else if (signpost instanceof TwoWaySignpost.MultiRelSignpost) {
            TwoWaySignpost.MultiRelSignpost relsSignpost = (TwoWaySignpost.MultiRelSignpost)signpost;
            for (long relId : relsSignpost.rels) {
                BitSet depths = (BitSet)this.relationshipPresenceAtDepth.get(relId);
                depths.clear(this.size());
                if (!depths.isEmpty()) continue;
                this.relationshipPresenceAtDepth.remove(relId);
            }
        }
        this.hooks.deactivateSignpost(this.lengthFromSource(), signpost);
        return signpost;
    }

    public boolean isTargetTrail() {
        return this.targetTrails.get(this.size());
    }
}

