/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.neo4j.collection.trackable.HeapTrackingIntObjectHashMap;
import org.neo4j.collection.trackable.HeapTrackingSkipList;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.GlobalState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.memory.MemoryTracker;

public final class Propagator
implements AutoCloseable {
    private final HeapTrackingIntObjectHashMap<HeapTrackingIntObjectHashMap<NodeStateSkipList>> nodesToPropagate;
    private final PPBFSHooks hooks;
    private final MemoryTracker mt;

    public Propagator(MemoryTracker memoryTracker, PPBFSHooks hooks) {
        this.mt = memoryTracker;
        this.hooks = hooks;
        this.nodesToPropagate = HeapTrackingIntObjectHashMap.createIntObjectHashMap((MemoryTracker)memoryTracker);
    }

    public void schedule(NodeState nodeState, int lengthFromSource, int lengthToTarget, GlobalState.ScheduleSource source) {
        this.hooks.schedule(nodeState, lengthFromSource, lengthToTarget, source);
        ((NodeStateSkipList)((Object)((HeapTrackingIntObjectHashMap)this.nodesToPropagate.getIfAbsentPut(lengthFromSource + lengthToTarget, (Function0 & Serializable)() -> HeapTrackingIntObjectHashMap.createIntObjectHashMap((MemoryTracker)this.mt))).getIfAbsentPut(lengthFromSource, (Function0 & Serializable)() -> new NodeStateSkipList(this.mt)))).insert(nodeState);
    }

    public void propagate(int totalLength) {
        int minLengthFromSourceToPropagate;
        this.hooks.propagate(this.nodesToPropagate, totalLength);
        assert (this.nodesToPropagate.keysView().allSatisfy((IntPredicate & Serializable)k -> k >= totalLength)) : "Propagation scheduled for previous depth; this will never be executed";
        HeapTrackingIntObjectHashMap nodesToPropagateForLength = (HeapTrackingIntObjectHashMap)this.nodesToPropagate.get(totalLength);
        if (nodesToPropagateForLength == null) {
            return;
        }
        for (int lengthFromSource = minLengthFromSourceToPropagate = nodesToPropagateForLength.keysView().min(); lengthFromSource <= totalLength; ++lengthFromSource) {
            int lengthToTarget = totalLength - lengthFromSource;
            this.hooks.propagateAllAtLengths(lengthFromSource, lengthToTarget);
            NodeStateSkipList nodesToPropagateAtLengthPair = (NodeStateSkipList)((Object)nodesToPropagateForLength.get(lengthFromSource));
            if (nodesToPropagateAtLengthPair == null) continue;
            NodeState node = (NodeState)nodesToPropagateAtLengthPair.pop();
            while (node != null) {
                node.propagateLengthPair(lengthFromSource, lengthToTarget);
                node = (NodeState)nodesToPropagateAtLengthPair.pop();
            }
            nodesToPropagateForLength.remove(lengthFromSource);
            nodesToPropagateAtLengthPair.close();
        }
        ((HeapTrackingIntObjectHashMap)this.nodesToPropagate.remove(totalLength)).close();
    }

    public boolean hasScheduled() {
        return this.nodesToPropagate.notEmpty();
    }

    @Override
    public void close() throws Exception {
        this.nodesToPropagate.forEach((Procedure & Serializable)map -> {
            map.forEach(HeapTrackingSkipList::close);
            map.close();
        });
        this.nodesToPropagate.close();
    }

    public static class NodeStateSkipList
    extends HeapTrackingSkipList<NodeState> {
        public NodeStateSkipList(MemoryTracker memoryTracker) {
            super(memoryTracker);
        }

        protected int compare(NodeState a, NodeState b) {
            int cmp = Long.compare(a.id(), b.id());
            return cmp != 0 ? cmp : Integer.compare(a.state().id(), b.state().id());
        }
    }
}

