/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.Arrays;
import java.util.BitSet;
import org.neo4j.common.EntityType;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.helpers.traversal.SlotOrName;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PGPathPropagatingBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.SignpostStack;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.RelationshipExpansion;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function0;

public final class PathTracer
extends PrefetchingIterator<TracedPath> {
    private final PPBFSHooks hooks;
    private final SignpostStack stack;
    private NodeState sourceNode;
    private int dgLength;
    private final BitSet protectFromPruning = new BitSet();
    private boolean shouldReturnSingleNodePath;
    private boolean ready = false;

    public boolean isSaturated() {
        return this.stack.target().isSaturated();
    }

    public PathTracer(MemoryTracker memoryTracker, PPBFSHooks hooks) {
        this.hooks = hooks;
        this.stack = new SignpostStack(memoryTracker, hooks);
    }

    public void reset() {
        super.reset();
        this.ready = false;
        this.sourceNode = null;
        this.stack.reset();
    }

    public void initialize(NodeState sourceNode, NodeState targetNode, int dgLength) {
        Preconditions.checkState((!this.ready ? 1 : 0) != 0, (String)"PathTracer was not reset before initializing");
        this.ready = true;
        this.sourceNode = sourceNode;
        this.stack.initialize(targetNode, dgLength);
        this.dgLength = dgLength;
        this.shouldReturnSingleNodePath = targetNode == sourceNode && dgLength == 0;
    }

    public boolean ready() {
        return this.ready;
    }

    private void popAndPrune() {
        TwoWaySignpost popped = this.stack.pop();
        if (popped == null) {
            return;
        }
        int sourceLength = this.stack.lengthFromSource();
        if (!popped.isVerifiedAtLength(sourceLength) && !this.protectFromPruning.get(this.stack.size())) {
            popped.pruneSourceLength(sourceLength);
        }
    }

    protected TracedPath fetchNextOrNull() {
        if (!this.ready) {
            throw new IllegalStateException("PathTracer attempted to iterate without initializing.");
        }
        if (this.shouldReturnSingleNodePath && !this.isSaturated()) {
            this.shouldReturnSingleNodePath = false;
            Preconditions.checkState((this.stack.lengthFromSource() == 0 ? 1 : 0) != 0, (String)"Attempting to return a path that does not reach the source");
            return this.stack.currentPath();
        }
        while (this.stack.hasNext()) {
            if (!this.stack.pushNext()) {
                this.popAndPrune();
                continue;
            }
            TwoWaySignpost sourceSignpost = this.stack.headSignpost();
            this.protectFromPruning.set(this.stack.size() - 1, false);
            if (this.stack.isTargetTrail() && !sourceSignpost.hasBeenTraced()) {
                sourceSignpost.setMinTargetDistance(this.stack.lengthToTarget(), PGPathPropagatingBFS.Phase.Tracing);
            }
            if (this.allNodesAreValidatedBetweenDuplicates()) {
                this.hooks.skippingDuplicateRelationship((Function0<TracedPath>)((Function0)this.stack::currentPath));
                this.stack.pop();
                continue;
            }
            if (sourceSignpost.prevNode != this.sourceNode || !this.validateTrail() || this.isSaturated()) continue;
            Preconditions.checkState((this.stack.lengthFromSource() == 0 ? 1 : 0) != 0, (String)"Attempting to return a path that does not reach the source");
            TracedPath path = this.stack.currentPath();
            this.hooks.returnPath(path);
            return path;
        }
        return null;
    }

    private boolean allNodesAreValidatedBetweenDuplicates() {
        int dup = this.stack.distanceToDuplicate();
        if (dup == 0) {
            return false;
        }
        int sourceLength = this.stack.lengthFromSource();
        for (int i = 0; i <= dup; ++i) {
            TwoWaySignpost candidate = this.stack.signpost(this.stack.size() - 1 - i);
            if (!candidate.prevNode.validatedAtLength(sourceLength)) {
                return false;
            }
            sourceLength += candidate.dataGraphLength();
        }
        this.protectFromPruning.set(this.stack.size() - 1 - dup, this.stack.size() - 1, true);
        return true;
    }

    private boolean validateTrail() {
        int sourceLength = 0;
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            TwoWaySignpost signpost = this.stack.signpost(i);
            sourceLength += signpost.dataGraphLength();
            if (signpost instanceof TwoWaySignpost.RelSignpost) {
                TwoWaySignpost.RelSignpost rel = (TwoWaySignpost.RelSignpost)signpost;
                BitSet bitset = (BitSet)this.stack.rels.get(rel.relId);
                assert (bitset.get(i));
                if (bitset.length() > i + 1) {
                    this.hooks.invalidTrail((Function0<TracedPath>)((Function0)this.stack::currentPath));
                    return false;
                }
            }
            if (signpost.isVerifiedAtLength(sourceLength)) continue;
            signpost.setVerified(sourceLength);
            if (signpost.forwardNode.validatedAtLength(sourceLength)) continue;
            signpost.forwardNode.validateSourceLength(sourceLength, this.dgLength - sourceLength);
        }
        return true;
    }

    public void decrementTargetCount() {
        this.stack.target().decrementTargetCount();
    }

    public record TracedPath(PathEntity[] entities) {
        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("(");
            PathEntity last = null;
            for (PathEntity e : this.entities) {
                switch (e.entityType) {
                    case NODE: {
                        if (last == null || last.entityType == EntityType.RELATIONSHIP) {
                            sb.append(e.id);
                            if (e.slotOrName == SlotOrName.none()) break;
                            sb.append("@").append(e.slotOrName);
                            break;
                        }
                        if (last.slotOrName == e.slotOrName) break;
                        sb.append(",").append(e.slotOrName);
                        break;
                    }
                    case RELATIONSHIP: {
                        sb.append(")-[").append(e.id).append("]->(");
                    }
                }
                last = e;
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TracedPath that = (TracedPath)o;
            return Arrays.equals(this.entities, that.entities);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.entities);
        }
    }

    public record PathEntity(SlotOrName slotOrName, long id, EntityType entityType) {
        static PathEntity fromNode(NodeState node) {
            return PathEntity.fromNode(node.state(), node.id());
        }

        static PathEntity fromNode(State state, long id) {
            return new PathEntity(state.slotOrName(), id, EntityType.NODE);
        }

        static PathEntity fromRel(TwoWaySignpost.RelSignpost signpost) {
            return PathEntity.fromRel(signpost.relationshipExpansion, signpost.relId);
        }

        static PathEntity fromRel(RelationshipExpansion expansion, long id) {
            return new PathEntity(expansion.slotOrName(), id, EntityType.RELATIONSHIP);
        }

        public AnyValue idValue() {
            return switch (this.entityType) {
                default -> throw new IncompatibleClassChangeError();
                case EntityType.NODE -> VirtualValues.node((long)this.id);
                case EntityType.RELATIONSHIP -> VirtualValues.relationship((long)this.id);
            };
        }
    }
}

