/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.List;
import org.eclipse.collections.api.tuple.primitive.LongObjectPair;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.FoundNodes;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.GlobalState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PGPathPropagatingBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.SearchMode;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TraversalDirection;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.NodeJuxtaposition;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.ProductGraphTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.RelationshipExpansion;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.memory.MemoryTracker;

final class BFSExpander
implements AutoCloseable {
    private final MemoryTracker mt;
    private final PPBFSHooks hooks;
    private final GlobalState globalState;
    private final ProductGraphTraversalCursor pgCursor;
    private final long intoTarget;
    private final HeapTrackingArrayList<State> statesList;
    private final FoundNodes foundNodes;

    public BFSExpander(FoundNodes foundNodes, GlobalState globalState, ProductGraphTraversalCursor pgCursor, long intoTarget, int nfaStateCount) {
        this.mt = globalState.mt;
        this.hooks = globalState.hooks;
        this.globalState = globalState;
        this.pgCursor = pgCursor;
        this.intoTarget = intoTarget;
        this.statesList = HeapTrackingArrayList.newArrayList((int)nfaStateCount, (MemoryTracker)this.mt);
        this.foundNodes = foundNodes;
    }

    public void discover(NodeState node, TraversalDirection direction) {
        this.hooks.discover(node, direction);
        this.foundNodes.addToBuffer(node);
        node.discover(direction);
        State state = node.state();
        block4: for (NodeJuxtaposition nj : state.getNodeJuxtapositions(direction)) {
            if (!nj.state(direction).test(node.id())) continue;
            switch (direction) {
                case Forward: {
                    NodeState nextNode = this.encounter(node.id(), nj.targetState(), direction);
                    TwoWaySignpost.NodeSignpost signpost = TwoWaySignpost.fromNodeJuxtaposition(this.mt, node, nextNode, this.foundNodes.forwardDepth());
                    if (this.globalState.searchMode != SearchMode.Unidirectional && nextNode.hasSourceSignpost(signpost)) continue block4;
                    nextNode.addSourceSignpost(signpost, this.foundNodes.forwardDepth());
                    continue block4;
                }
                case Backward: {
                    NodeState nextNode = this.encounter(node.id(), nj.sourceState(), direction);
                    TwoWaySignpost.NodeSignpost signpost = TwoWaySignpost.fromNodeJuxtaposition(this.mt, nextNode, node);
                    if (nextNode.hasTargetSignpost(signpost)) continue block4;
                    TwoWaySignpost.NodeSignpost addedSignpost = node.upsertSourceSignpost(signpost);
                    addedSignpost.setMinTargetDistance(this.foundNodes.backwardDepth(), PGPathPropagatingBFS.Phase.Expansion);
                }
            }
        }
    }

    public NodeState encounter(long nodeId, State state, TraversalDirection direction) {
        NodeState nodeState = this.foundNodes.get(nodeId, state.id());
        if (nodeState == null) {
            nodeState = new NodeState(this.globalState, nodeId, state, this.intoTarget);
            this.discover(nodeState, direction);
        } else if (this.globalState.searchMode == SearchMode.Bidirectional && !nodeState.hasBeenSeen(direction)) {
            this.discover(nodeState, direction);
        }
        return nodeState;
    }

    public void expand() {
        this.foundNodes.openBuffer();
        TraversalDirection direction = this.foundNodes.getNextExpansionDirection();
        this.hooks.expand(direction, this.foundNodes);
        for (LongObjectPair pair : this.foundNodes.frontier(direction).keyValuesView()) {
            long dbNodeId = pair.getOne();
            HeapTrackingArrayList statesById = (HeapTrackingArrayList)pair.getTwo();
            this.statesList.clear();
            for (NodeState nodeState : statesById) {
                if (nodeState == null) continue;
                this.statesList.add((Object)nodeState.state());
            }
            this.hooks.expandNode(dbNodeId, this.statesList, direction);
            this.pgCursor.setNodeAndStates(dbNodeId, (List<State>)this.statesList, direction);
            block6: while (this.pgCursor.next()) {
                long foundNode = this.pgCursor.otherNodeReference();
                RelationshipExpansion re = this.pgCursor.relationshipExpansion();
                switch (direction) {
                    case Forward: {
                        NodeState nextNode = this.encounter(foundNode, re.targetState(), direction);
                        NodeState node = (NodeState)statesById.get(re.sourceState().id());
                        TwoWaySignpost.RelSignpost signpost = TwoWaySignpost.fromRelExpansion(this.mt, node, this.pgCursor.relationshipReference(), nextNode, re, this.foundNodes.forwardDepth());
                        if (this.globalState.searchMode != SearchMode.Unidirectional && nextNode.hasSourceSignpost(signpost)) continue block6;
                        nextNode.addSourceSignpost(signpost, this.foundNodes.forwardDepth());
                        break;
                    }
                    case Backward: {
                        NodeState nextNode = this.encounter(foundNode, re.sourceState(), direction);
                        NodeState node = (NodeState)statesById.get(re.targetState().id());
                        TwoWaySignpost.RelSignpost signpost = TwoWaySignpost.fromRelExpansion(this.mt, nextNode, this.pgCursor.relationshipReference(), node, re);
                        if (nextNode.hasTargetSignpost(signpost)) break;
                        TwoWaySignpost.RelSignpost addedSignpost = node.upsertSourceSignpost(signpost);
                        addedSignpost.setMinTargetDistance(this.foundNodes.backwardDepth(), PGPathPropagatingBFS.Phase.Expansion);
                    }
                }
            }
        }
        this.foundNodes.commitBuffer(direction);
    }

    public void setTracer(KernelReadTracer tracer) {
        this.pgCursor.setTracer(tracer);
    }

    @Override
    public void close() throws Exception {
        this.pgCursor.close();
        this.statesList.close();
    }
}

