/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.neo4j.collection.trackable.HeapTrackingIntObjectHashMap;
import org.neo4j.collection.trackable.HeapTrackingUnifiedSet;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.memory.MemoryTracker;

public final class Propagator
implements AutoCloseable {
    private final HeapTrackingIntObjectHashMap<HeapTrackingIntObjectHashMap<HeapTrackingUnifiedSet<NodeState>>> nodesToPropagate;
    private final PPBFSHooks hooks;
    private final MemoryTracker mt;

    public Propagator(MemoryTracker memoryTracker, PPBFSHooks hooks) {
        this.mt = memoryTracker;
        this.hooks = hooks;
        this.nodesToPropagate = HeapTrackingIntObjectHashMap.createIntObjectHashMap((MemoryTracker)memoryTracker);
    }

    public void schedule(NodeState nodeState, int lengthFromSource, int lengthToTarget) {
        this.hooks.schedulePropagation(nodeState, lengthFromSource, lengthToTarget);
        ((HeapTrackingUnifiedSet)((HeapTrackingIntObjectHashMap)this.nodesToPropagate.getIfAbsentPut(lengthFromSource + lengthToTarget, (Function0 & Serializable)() -> HeapTrackingIntObjectHashMap.createIntObjectHashMap((MemoryTracker)this.mt))).getIfAbsentPut(lengthFromSource, (Function0 & Serializable)() -> HeapTrackingUnifiedSet.createUnifiedSet((MemoryTracker)this.mt))).add((Object)nodeState);
    }

    public void propagate(int totalLength) {
        int minLengthFromSourceToPropagate;
        assert (this.nodesToPropagate.keysView().allSatisfy((IntPredicate & Serializable)k -> k >= totalLength)) : "The current implementation is structured such that we never should schedule nodes to propagate for a depth which has already passed. If we do (as the algo is implemented here), we will loop for ever.";
        this.hooks.propagateAll(this.nodesToPropagate, totalLength);
        HeapTrackingIntObjectHashMap nodesToPropagateForLength = (HeapTrackingIntObjectHashMap)this.nodesToPropagate.get(totalLength);
        if (nodesToPropagateForLength == null) {
            return;
        }
        for (int lengthFromSource = minLengthFromSourceToPropagate = nodesToPropagateForLength.keysView().min(); lengthFromSource <= totalLength; ++lengthFromSource) {
            int lengthToTarget = totalLength - lengthFromSource;
            this.hooks.propagateAllAtLengths(lengthFromSource, lengthToTarget);
            HeapTrackingUnifiedSet nodesToPropagateAtLengthPair = (HeapTrackingUnifiedSet)nodesToPropagateForLength.get(lengthFromSource);
            if (nodesToPropagateAtLengthPair == null) continue;
            while (nodesToPropagateAtLengthPair.notEmpty()) {
                NodeState node = (NodeState)nodesToPropagateAtLengthPair.getLast();
                nodesToPropagateAtLengthPair.remove((Object)node);
                node.propagateLengthPair(lengthFromSource, lengthToTarget);
            }
            nodesToPropagateForLength.remove(lengthFromSource);
            nodesToPropagateAtLengthPair.close();
        }
        ((HeapTrackingIntObjectHashMap)this.nodesToPropagate.remove(totalLength)).close();
    }

    public boolean hasScheduled() {
        return this.nodesToPropagate.notEmpty();
    }

    @Override
    public void close() throws Exception {
        this.nodesToPropagate.forEach((Procedure & Serializable)map -> {
            map.forEach(HeapTrackingUnifiedSet::close);
            map.close();
        });
        this.nodesToPropagate.close();
    }
}

