/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.BFSExpander;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.FoundNodes;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.GlobalState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PathTracer;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.Propagator;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TargetTracker;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.ProductGraphTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.memory.MemoryTracker;

public final class PGPathPropagatingBFS<Row>
extends PrefetchingIterator<Row>
implements AutoCloseable {
    private final GlobalState globalState;
    private final BFSExpander bfsExpander;
    private final NodeState sourceData;
    private final long intoTarget;
    private final PathTracer pathTracer;
    private final Function<PathTracer.TracedPath, Row> toRow;
    private final Predicate<Row> nonInlinedPredicate;
    private final Boolean isGroupSelector;
    private final MemoryTracker memoryTracker;
    private final PPBFSHooks hooks;
    private final AssertOpen assertOpen;
    private final Propagator propagator;
    private final FoundNodes foundNodes;
    private final TargetTracker targets;
    private int nextDepth = 0;
    private Iterator<NodeState> currentTargets = Collections.emptyIterator();
    private boolean targetSaturated = false;
    private boolean groupYielded = false;

    public PGPathPropagatingBFS(long source, long intoTarget, State startState, ProductGraphTraversalCursor.DataGraphRelationshipCursor graphCursor, PathTracer pathTracer, Function<PathTracer.TracedPath, Row> toRow, Predicate<Row> nonInlinedPredicate, Boolean isGroupSelector, int initialCountForTargetNodes, int nfaStateCount, MemoryTracker mt, PPBFSHooks hooks, AssertOpen assertOpen) {
        this.intoTarget = intoTarget;
        this.pathTracer = pathTracer;
        this.toRow = toRow;
        this.nonInlinedPredicate = nonInlinedPredicate;
        this.isGroupSelector = isGroupSelector;
        this.memoryTracker = mt.getScopedMemoryTracker();
        this.hooks = hooks;
        this.assertOpen = assertOpen;
        this.foundNodes = new FoundNodes(this.memoryTracker, nfaStateCount);
        this.targets = new TargetTracker(this.memoryTracker, hooks);
        this.propagator = new Propagator(this.memoryTracker, hooks);
        this.globalState = new GlobalState(this.propagator, this.targets, this.memoryTracker, hooks, initialCountForTargetNodes);
        ProductGraphTraversalCursor cursor = new ProductGraphTraversalCursor(graphCursor, this.memoryTracker);
        this.bfsExpander = new BFSExpander(this.foundNodes, this.globalState, cursor, intoTarget, nfaStateCount);
        this.sourceData = new NodeState(this.globalState, source, startState, intoTarget);
        this.memoryTracker.allocateHeap(this.sourceData.estimatedHeapUsage());
        pathTracer.reset();
        this.hooks.newRow(source);
    }

    public static <Row> PGPathPropagatingBFS<Row> create(long source, long intoTarget, State startState, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, PathTracer pathTracer, Function<PathTracer.TracedPath, Row> toRow, Predicate<Row> nonInlinedPredicate, Boolean isGroupSelector, int initialCountForTargetNodes, int numberOfNfaStates, MemoryTracker mt, PPBFSHooks hooks, AssertOpen assertOpen) {
        return new PGPathPropagatingBFS<Row>(source, intoTarget, startState, new ProductGraphTraversalCursor.DataGraphRelationshipCursorImpl(read, nodeCursor, relCursor), pathTracer, toRow, nonInlinedPredicate, isGroupSelector, initialCountForTargetNodes, numberOfNfaStates, mt, hooks, assertOpen);
    }

    protected Row fetchNextOrNull() {
        if (this.targetSaturated) {
            return null;
        }
        while (true) {
            if (this.pathTracer.ready()) {
                while (this.pathTracer.hasNext()) {
                    PathTracer.TracedPath path = (PathTracer.TracedPath)this.pathTracer.next();
                    Row row = this.toRow.apply(path);
                    if (!this.nonInlinedPredicate.test(row)) continue;
                    if (this.isGroupSelector.booleanValue()) {
                        this.groupYielded = true;
                    } else {
                        this.pathTracer.decrementTargetCount();
                    }
                    if (this.intoTarget != -1L && this.pathTracer.isSaturated()) {
                        this.targetSaturated = true;
                    }
                    return row;
                }
            }
            if (this.groupYielded) {
                this.groupYielded = false;
                this.pathTracer.decrementTargetCount();
                if (this.intoTarget != -1L && this.pathTracer.isSaturated()) {
                    this.targetSaturated = true;
                    return null;
                }
            }
            if (!this.currentTargets.hasNext()) {
                if (this.nextLevelWithTargets()) {
                    this.currentTargets = this.targets.iterate();
                } else {
                    this.targetSaturated = true;
                    return null;
                }
            }
            this.pathTracer.reset();
            this.pathTracer.initialize(this.sourceData, this.currentTargets.next(), this.nextDepth);
        }
    }

    private boolean nextLevelWithTargets() {
        if (this.zeroHopLevel()) {
            return true;
        }
        do {
            if (this.shouldQuit()) {
                return false;
            }
            if (this.nextLevel()) continue;
            return false;
        } while (!this.targets.hasTargets());
        return true;
    }

    private boolean shouldQuit() {
        return this.targets.allKnownTargetsSaturated() && !this.foundNodes.hasMore();
    }

    private boolean nextLevel() {
        this.assertOpen.assertOpen();
        ++this.nextDepth;
        this.hooks.nextLevel(this.nextDepth);
        this.targets.clear();
        if (this.foundNodes.hasMore()) {
            this.bfsExpander.expand();
        } else if (!this.propagator.hasScheduled()) {
            this.hooks.noMoreNodes();
            return false;
        }
        this.propagator.propagate(this.nextDepth);
        return true;
    }

    private boolean zeroHopLevel() {
        if (this.foundNodes.depth() > 0) {
            return false;
        }
        this.hooks.nextLevel(0);
        this.bfsExpander.discover(this.sourceData);
        if (this.sourceData.isTarget()) {
            this.targets.addTarget(this.sourceData);
        }
        this.bfsExpander.expand();
        return this.targets.hasCurrentUnsaturatedTargets();
    }

    public void setTracer(KernelReadTracer tracer) {
        this.bfsExpander.setTracer(tracer);
    }

    @Override
    public void close() throws Exception {
        this.foundNodes.close();
        this.bfsExpander.close();
        this.targets.close();
        this.propagator.close();
        this.memoryTracker.close();
    }
}

