/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.BitSet;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.internal.kernel.api.helpers.traversal.SlotOrName;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.GlobalState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public final class NodeState
implements AutoCloseable,
Measurable {
    private static final int NO_SOURCE_DISTANCE = -1;
    private static final int SIGNPOSTS_INIT_SIZE = 2;
    private final long nodeId;
    private final State state;
    final GlobalState globalState;
    private final HeapTrackingArrayList<TwoWaySignpost> sourceSignposts;
    private HeapTrackingArrayList<TwoWaySignpost> targetSignposts;
    private final BitSet lengthsFromSource;
    private final BitSet validatedLengthsFromSource;
    private int sourceDistance = -1;
    private int remainingTargetCount = 0;
    private boolean isTarget = false;
    private static long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeState.class);
    private static long BITSET_MIN_SIZE = HeapEstimator.shallowSizeOfInstance(BitSet.class) + HeapEstimator.sizeOfLongArray((int)1);

    public NodeState(GlobalState globalState, long nodeId, State state, long intoTarget) {
        this.sourceSignposts = HeapTrackingArrayList.newArrayList((int)2, (MemoryTracker)globalState.mt);
        this.nodeId = nodeId;
        this.state = state;
        this.globalState = globalState;
        this.lengthsFromSource = new BitSet();
        this.validatedLengthsFromSource = new BitSet();
        if (this.state().isFinalState() && (intoTarget == -1L || intoTarget == nodeId)) {
            this.remainingTargetCount = (int)globalState.initialCountForTargetNodes;
            this.isTarget = true;
            globalState.incrementUnsaturatedTargets();
        }
        globalState.mt.allocateHeap(this.estimatedHeapUsage());
    }

    public State state() {
        return this.state;
    }

    public boolean isTarget() {
        return this.isTarget;
    }

    public int nextSignpostIndexForLength(int currentIndex, int lengthFromSource) {
        for (int i = currentIndex + 1; i < this.sourceSignposts.size(); ++i) {
            if (!((TwoWaySignpost)this.sourceSignposts.get(i)).hasSourceLength(lengthFromSource)) continue;
            return i;
        }
        return -1;
    }

    public TwoWaySignpost getSourceSignpost(int index) {
        return (TwoWaySignpost)this.sourceSignposts.get(index);
    }

    public void synchronizeLengthAfterPrune(int lengthFromSource) {
        for (TwoWaySignpost sourceSignpost : this.sourceSignposts) {
            if (!sourceSignpost.hasSourceLength(lengthFromSource)) continue;
            return;
        }
        assert (!this.validatedLengthsFromSource.get(lengthFromSource)) : "We should never remove validated length states";
        this.lengthsFromSource.set(lengthFromSource, false);
    }

    public boolean validatedAtLength(int lengthFromSource) {
        return this.validatedLengthsFromSource.get(lengthFromSource);
    }

    @Override
    public void close() {
        this.sourceSignposts.close();
        if (this.targetSignposts != null) {
            this.targetSignposts.close();
        }
    }

    public long id() {
        return this.nodeId;
    }

    public void addSourceSignpost(TwoWaySignpost sourceSignpost, int lengthFromSource) {
        Preconditions.checkArgument((sourceSignpost.forwardNode == this ? 1 : 0) != 0, (String)"Source signpost must be added to correct node");
        if (this.sourceDistance == -1 || this.sourceDistance > lengthFromSource) {
            this.sourceDistance = lengthFromSource;
        }
        this.globalState.hooks.addSourceSignpost(sourceSignpost, lengthFromSource);
        if (!this.lengthsFromSource.get(lengthFromSource)) {
            this.lengthsFromSource.set(lengthFromSource);
            int minDistToTarget = this.minDistToTarget();
            if (minDistToTarget != -1) {
                Preconditions.checkState((lengthFromSource > this.realSourceDistance() ? 1 : 0) != 0, (String)"When we find a shortest path to a node we shouldn't have TargetSignposts");
                this.globalState.schedule(this, lengthFromSource, minDistToTarget);
            }
            if (this.isTarget()) {
                this.globalState.addTarget(this);
            }
        } else assert (lengthFromSource == this.lengthsFromSource.stream().max().orElseThrow()) : "A node should only be seen by the BFS at increasingly deeper levels.";
        this.sourceSignposts.add((Object)sourceSignpost);
    }

    public void newPropagatedLengthFromSource(int lengthFromSource, int lengthToTarget) {
        if (!this.lengthsFromSource.get(lengthFromSource)) {
            this.lengthsFromSource.set(lengthFromSource);
            if (this.hasMinDistToTarget(lengthToTarget)) {
                Preconditions.checkState((lengthFromSource > this.realSourceDistance() ? 1 : 0) != 0, (String)"When we find a shortest path to a node we shouldn't have TargetSignposts");
                this.globalState.schedule(this, lengthFromSource, lengthToTarget);
            }
            if (this.isTarget()) {
                this.globalState.addTarget(this);
            }
        }
    }

    public void addTargetSignpost(TwoWaySignpost targetSignpost, int lengthToTarget) {
        this.globalState.hooks.addTargetSignpost(targetSignpost, lengthToTarget);
        Preconditions.checkArgument((targetSignpost.prevNode == this ? 1 : 0) != 0, (String)"Target signpost must be added to correct node");
        boolean firstTrace = false;
        if (this.targetSignposts == null) {
            this.targetSignposts = HeapTrackingArrayList.newArrayList((int)2, (MemoryTracker)this.globalState.mt);
            firstTrace = true;
        }
        assert (!firstTrace || lengthToTarget >= this.minDistToTarget()) : "The first time a node is traced should be with the shortest trail to a target";
        if (!this.hasMinDistToTarget(lengthToTarget)) {
            int lengthFromSource = this.lengthsFromSource.nextSetBit(0);
            while (lengthFromSource != -1) {
                Preconditions.checkState((boolean)this.lengthsFromSource.get(lengthFromSource), (String)"");
                if ((firstTrace || this.validatedLengthsFromSource.get(lengthFromSource)) && lengthFromSource != this.realSourceDistance()) {
                    this.globalState.schedule(this, lengthFromSource, lengthToTarget);
                }
                lengthFromSource = this.lengthsFromSource.nextSetBit(lengthFromSource + 1);
            }
        }
        this.targetSignposts.add((Object)targetSignpost);
    }

    private int realSourceDistance() {
        if (this.sourceDistance == -1) {
            return 0;
        }
        return this.sourceDistance;
    }

    public void propagateLengthPair(int lengthFromSource, int lengthToTarget) {
        this.globalState.hooks.propagateLengthPair(this, lengthFromSource, lengthToTarget);
        if (!this.hasAnyMinDistToTarget()) {
            return;
        }
        for (TwoWaySignpost tsp : this.targetSignposts) {
            if (tsp.minDistToTarget() != lengthToTarget) continue;
            tsp.propagate(lengthFromSource, lengthToTarget);
        }
    }

    public void validateLengthState(int lengthFromSource, int tracedLengthToTarget) {
        this.globalState.hooks.validateLengthState(this, lengthFromSource, tracedLengthToTarget);
        Preconditions.checkState((!this.validatedLengthsFromSource.get(lengthFromSource) ? 1 : 0) != 0, (String)"Shouldn't validate the same length from source more than once");
        assert (this.hasAnyMinDistToTarget() || tracedLengthToTarget == 0 && this.isTarget()) : "We only validate length states during tracing, and any traced node which isn't the target node of a path should've had a TargetSignpost registered in targetSignpostsByMinDist before being validated";
        assert (this.isTarget() && tracedLengthToTarget == 0 || tracedLengthToTarget == this.minDistToTarget()) : "First time tracing should be with shortest length to target";
        this.validatedLengthsFromSource.set(lengthFromSource);
        if (!this.hasAnyMinDistToTarget()) {
            return;
        }
        for (TwoWaySignpost tsp : this.targetSignposts) {
            int lengthToTarget = tsp.minDistToTarget();
            if (lengthToTarget == -1) continue;
            Preconditions.checkState((lengthToTarget >= tracedLengthToTarget ? 1 : 0) != 0, (String)"First time tracing should be with shortest length to target");
            if (lengthToTarget <= tracedLengthToTarget) continue;
            this.globalState.schedule(this, lengthFromSource, lengthToTarget);
        }
    }

    public void decrementTargetCount() {
        this.globalState.hooks.decrementTargetCount(this, this.remainingTargetCount);
        --this.remainingTargetCount;
        Preconditions.checkState((this.remainingTargetCount >= 0 ? 1 : 0) != 0, (String)"Target count should never be negative");
        if (this.remainingTargetCount == 0) {
            this.globalState.decrementUnsaturatedTargets();
        }
    }

    public boolean hasMinDistToTarget(int minDistToTarget) {
        if (this.targetSignposts == null) {
            return false;
        }
        for (TwoWaySignpost tsp : this.targetSignposts) {
            if (tsp.minDistToTarget() != minDistToTarget) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyMinDistToTarget() {
        boolean res = this.targetSignposts != null;
        Preconditions.checkState((!res || this.targetSignposts.notEmpty() ? 1 : 0) != 0, (String)"If targetSignposts isn't null it's never supposed to be empty");
        return res;
    }

    private int minDistToTarget() {
        if (this.targetSignposts == null) {
            return -1;
        }
        int min = Integer.MAX_VALUE;
        for (TwoWaySignpost tsp : this.targetSignposts) {
            int curr = tsp.minDistToTarget();
            if (curr == -1 || curr >= min) continue;
            min = curr;
        }
        return min == Integer.MAX_VALUE ? -1 : min;
    }

    public String toString() {
        String stateName = String.valueOf(this.state.id());
        SlotOrName slotOrName = this.state.slotOrName();
        if (slotOrName instanceof SlotOrName.VarName) {
            SlotOrName.VarName name = (SlotOrName.VarName)slotOrName;
            stateName = name.name();
        }
        return "(" + this.nodeId + "," + stateName + ")";
    }

    public boolean isSaturated() {
        return this.remainingTargetCount == 0;
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + BITSET_MIN_SIZE + BITSET_MIN_SIZE;
    }
}

