/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.List;
import org.eclipse.collections.api.tuple.primitive.LongObjectPair;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.FoundNodes;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.GlobalState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeState;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.NodeJuxtaposition;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.ProductGraphTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.memory.MemoryTracker;

final class BFSExpander
implements AutoCloseable {
    private final MemoryTracker mt;
    private final PPBFSHooks hooks;
    private final GlobalState globalState;
    private final ProductGraphTraversalCursor pgCursor;
    private final long intoTarget;
    private final HeapTrackingArrayList<State> statesList;
    private final FoundNodes foundNodes;

    public BFSExpander(FoundNodes foundNodes, GlobalState globalState, ProductGraphTraversalCursor pgCursor, long intoTarget, int nfaStateCount) {
        this.mt = globalState.mt;
        this.hooks = globalState.hooks;
        this.globalState = globalState;
        this.pgCursor = pgCursor;
        this.intoTarget = intoTarget;
        this.statesList = HeapTrackingArrayList.newArrayList((int)nfaStateCount, (MemoryTracker)this.mt);
        this.foundNodes = foundNodes;
    }

    public void discover(NodeState node) {
        this.foundNodes.addToBuffer(node);
        State state = node.state();
        for (NodeJuxtaposition nj : state.getNodeJuxtapositions()) {
            if (!nj.testNode(node.id())) continue;
            NodeState nextNode = this.encounter(node.id(), nj.targetState());
            nextNode.addSourceSignpost(TwoWaySignpost.fromNodeJuxtaposition(this.mt, node, nextNode, this.foundNodes.depth()), this.foundNodes.depth());
        }
    }

    private NodeState encounter(long nodeId, State state) {
        NodeState nextNode = this.foundNodes.get(nodeId, state.id());
        if (nextNode == null) {
            nextNode = new NodeState(this.globalState, nodeId, state, this.intoTarget);
            this.discover(nextNode);
        }
        return nextNode;
    }

    public void expand() {
        for (LongObjectPair pair : this.foundNodes.frontier().keyValuesView()) {
            long dbNodeId = pair.getOne();
            HeapTrackingArrayList statesById = (HeapTrackingArrayList)pair.getTwo();
            this.statesList.clear();
            for (NodeState nodeState : statesById) {
                if (nodeState == null) continue;
                this.statesList.add((Object)nodeState.state());
            }
            this.pgCursor.setNodeAndStates(dbNodeId, (List<State>)this.statesList);
            while (this.pgCursor.next()) {
                long foundNode = this.pgCursor.otherNodeReference();
                NodeState nextNode = this.encounter(foundNode, this.pgCursor.targetState());
                NodeState currentNode = (NodeState)statesById.get(this.pgCursor.currentInputState().id());
                TwoWaySignpost.RelSignpost signpost = TwoWaySignpost.fromRelExpansion(this.mt, currentNode, this.pgCursor.relationshipReference(), nextNode, this.pgCursor.relationshipExpansion(), this.foundNodes.depth());
                nextNode.addSourceSignpost(signpost, this.foundNodes.depth());
            }
        }
        this.foundNodes.shuffleFrontiers();
    }

    public void setTracer(KernelReadTracer tracer) {
        this.pgCursor.setTracer(tracer);
    }

    @Override
    public void close() throws Exception {
        this.pgCursor.close();
        this.statesList.close();
    }
}

