/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.helpers.UnionTokenIndexCursor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;

public abstract class UnionRelationshipTypeIndexCursor
extends UnionTokenIndexCursor<RelationshipTypeIndexCursor>
implements RelationshipIndexCursor {
    public static UnionRelationshipTypeIndexCursor ascendingUnionRelationshipTypeIndexCursor(Read read, TokenReadSession tokenReadSession, CursorContext cursorContext, int[] types, RelationshipTypeIndexCursor[] cursors) throws KernelException {
        assert (types.length == cursors.length);
        for (int i = 0; i < types.length; ++i) {
            read.relationshipTypeScan(tokenReadSession, cursors[i], IndexQueryConstraints.ordered((IndexOrder)IndexOrder.ASCENDING), new TokenPredicate(types[i]), cursorContext);
        }
        return new AscendingUnionRelationshipTypeIndexCursor(cursors);
    }

    public static UnionRelationshipTypeIndexCursor descendingUnionRelationshipTypeIndexCursor(Read read, TokenReadSession tokenReadSession, CursorContext cursorContext, int[] types, RelationshipTypeIndexCursor[] cursors) throws KernelException {
        assert (types.length == cursors.length);
        for (int i = 0; i < types.length; ++i) {
            read.relationshipTypeScan(tokenReadSession, cursors[i], IndexQueryConstraints.ordered((IndexOrder)IndexOrder.DESCENDING), new TokenPredicate(types[i]), cursorContext);
        }
        return new DescendingUnionRelationshipTypeIndexCursor(cursors);
    }

    public static UnionRelationshipTypeIndexCursor unionRelationshipTypeIndexCursor(RelationshipTypeIndexCursor[] cursors) {
        return new AscendingUnionRelationshipTypeIndexCursor(cursors);
    }

    UnionRelationshipTypeIndexCursor(RelationshipTypeIndexCursor[] cursors) {
        super((Cursor[])cursors);
    }

    @Override
    long reference(RelationshipTypeIndexCursor cursor) {
        return cursor.relationshipReference();
    }

    public boolean readFromStore() {
        return ((RelationshipTypeIndexCursor)this.current()).readFromStore();
    }

    public long sourceNodeReference() {
        return ((RelationshipTypeIndexCursor)this.current()).sourceNodeReference();
    }

    public long targetNodeReference() {
        return ((RelationshipTypeIndexCursor)this.current()).targetNodeReference();
    }

    public int type() {
        return ((RelationshipTypeIndexCursor)this.current()).type();
    }

    public void properties(PropertyCursor cursor, PropertySelection selection) {
        ((RelationshipTypeIndexCursor)this.current()).properties(cursor, selection);
    }

    public Reference propertiesReference() {
        return ((RelationshipTypeIndexCursor)this.current()).propertiesReference();
    }

    public long relationshipReference() {
        return this.reference();
    }

    public void source(NodeCursor cursor) {
        ((RelationshipTypeIndexCursor)this.current()).source(cursor);
    }

    public void target(NodeCursor cursor) {
        ((RelationshipTypeIndexCursor)this.current()).target(cursor);
    }

    public float score() {
        return Float.NaN;
    }

    private static final class AscendingUnionRelationshipTypeIndexCursor
    extends UnionRelationshipTypeIndexCursor {
        AscendingUnionRelationshipTypeIndexCursor(RelationshipTypeIndexCursor[] cursors) {
            super(cursors);
        }

        @Override
        int compare(long current, long other) {
            return Long.compare(current, other);
        }

        @Override
        long extremeValue() {
            return Long.MAX_VALUE;
        }
    }

    private static final class DescendingUnionRelationshipTypeIndexCursor
    extends UnionRelationshipTypeIndexCursor {
        DescendingUnionRelationshipTypeIndexCursor(RelationshipTypeIndexCursor[] cursors) {
            super(cursors);
        }

        @Override
        int compare(long current, long other) {
            return -Long.compare(current, other);
        }

        @Override
        long extremeValue() {
            return Long.MIN_VALUE;
        }
    }
}

