/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.helpers.CompositeCursor;
import org.neo4j.internal.kernel.api.helpers.IntersectionNodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.helpers.SkippableCompositeCursor;
import org.neo4j.io.pagecache.context.CursorContext;

public abstract class SubtractionNodeLabelIndexCursor
extends DefaultCloseListenable
implements CompositeCursor {
    private final SkippableCompositeCursor positiveCursor;
    private final SkippableCompositeCursor negativeCursor;
    private boolean negativeCursorHasData;
    private boolean first = true;

    public static SubtractionNodeLabelIndexCursor ascendingSubtractionNodeLabelIndexCursor(Read read, TokenReadSession tokenReadSession, CursorContext cursorContext, int[] positiveLabels, int[] negativeLabels, NodeLabelIndexCursor[] positiveCursors, NodeLabelIndexCursor[] negativeCursors) throws KernelException {
        return new AscendingSubtractionLabelIndexCursor(IntersectionNodeLabelIndexCursor.ascendingIntersectionNodeLabelIndexCursor(read, tokenReadSession, cursorContext, positiveLabels, positiveCursors), IntersectionNodeLabelIndexCursor.ascendingIntersectionNodeLabelIndexCursor(read, tokenReadSession, cursorContext, negativeLabels, negativeCursors));
    }

    public static SubtractionNodeLabelIndexCursor descendingSubtractionNodeLabelIndexCursor(Read read, TokenReadSession tokenReadSession, CursorContext cursorContext, int[] positiveLabels, int[] negativeLabels, NodeLabelIndexCursor[] positiveCursors, NodeLabelIndexCursor[] negativeCursors) throws KernelException {
        return new DescendingSubtractionLabelIndexCursor(IntersectionNodeLabelIndexCursor.descendingIntersectionNodeLabelIndexCursor(read, tokenReadSession, cursorContext, positiveLabels, positiveCursors), IntersectionNodeLabelIndexCursor.descendingIntersectionNodeLabelIndexCursor(read, tokenReadSession, cursorContext, negativeLabels, negativeCursors));
    }

    public static SubtractionNodeLabelIndexCursor subtractionNodeLabelIndexCursor(NodeLabelIndexCursor[] positiveCursors, NodeLabelIndexCursor[] negativeCursor) {
        return new AscendingSubtractionLabelIndexCursor(IntersectionNodeLabelIndexCursor.intersectionNodeLabelIndexCursor(positiveCursors), IntersectionNodeLabelIndexCursor.intersectionNodeLabelIndexCursor(negativeCursor));
    }

    SubtractionNodeLabelIndexCursor(SkippableCompositeCursor positiveCursor, SkippableCompositeCursor negativeCursor) {
        this.positiveCursor = positiveCursor;
        this.negativeCursor = negativeCursor;
    }

    @Override
    public long reference() {
        return this.positiveCursor.reference();
    }

    public void closeInternal() {
    }

    public boolean isClosed() {
        return false;
    }

    abstract int compare(long var1, long var3);

    public boolean next() {
        if (this.first) {
            this.negativeCursorHasData = this.negativeCursor.next();
            this.first = false;
        }
        boolean shouldContinue = this.positiveCursor.next();
        boolean localNegativeCursorHasData = this.negativeCursorHasData;
        while (shouldContinue) {
            if (!localNegativeCursorHasData) {
                return true;
            }
            long positiveId = this.positiveCursor.reference();
            int compare = this.compare(positiveId, this.negativeCursor.reference());
            if (compare < 0) {
                return true;
            }
            if (compare > 0) {
                this.negativeCursor.skipUntil(positiveId);
                localNegativeCursorHasData = this.negativeCursor.next();
            } else {
                shouldContinue = this.positiveCursor.next();
                if (shouldContinue) {
                    this.negativeCursor.skipUntil(positiveId);
                    localNegativeCursorHasData = this.negativeCursor.next();
                }
            }
            this.negativeCursorHasData = localNegativeCursorHasData;
        }
        return false;
    }

    public void setTracer(KernelReadTracer tracer) {
        this.positiveCursor.setTracer(tracer);
        this.negativeCursor.setTracer(tracer);
    }

    public void removeTracer() {
        this.positiveCursor.removeTracer();
        this.negativeCursor.removeTracer();
    }

    private static final class AscendingSubtractionLabelIndexCursor
    extends SubtractionNodeLabelIndexCursor {
        AscendingSubtractionLabelIndexCursor(SkippableCompositeCursor positiveCursor, SkippableCompositeCursor negativeCursor) {
            super(positiveCursor, negativeCursor);
        }

        @Override
        int compare(long current, long other) {
            return Long.compare(current, other);
        }
    }

    private static final class DescendingSubtractionLabelIndexCursor
    extends SubtractionNodeLabelIndexCursor {
        DescendingSubtractionLabelIndexCursor(SkippableCompositeCursor positiveCursor, SkippableCompositeCursor negativeCursor) {
            super(positiveCursor, negativeCursor);
        }

        @Override
        int compare(long current, long other) {
            return -Long.compare(current, other);
        }
    }
}

