/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.Arrays;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.util.Preconditions;

public abstract class UnionTokenIndexCursor<CURSOR extends Cursor>
extends DefaultCloseListenable
implements Cursor {
    private static final int UNINITIALIZED = -1;
    private final CURSOR[] cursors;
    private int currentCursorIndex = -1;

    UnionTokenIndexCursor(CURSOR[] cursors) {
        assert (cursors != null && cursors.length > 0);
        this.cursors = (Cursor[])Arrays.copyOf(cursors, cursors.length);
    }

    abstract boolean compare(long var1, long var3);

    abstract long reference(CURSOR var1);

    abstract long extremeValue();

    public final boolean next() {
        if (this.currentCursorIndex == -1) {
            return this.initialize();
        }
        return this.internalNext();
    }

    private boolean internalNext() {
        if (this.cursors[this.currentCursorIndex].next()) {
            this.findNext(this.reference(this.cursors[this.currentCursorIndex]));
            return true;
        }
        int oldCursorIndex = this.currentCursorIndex;
        this.cursors[oldCursorIndex] = null;
        this.findNext(this.extremeValue());
        return this.currentCursorIndex != oldCursorIndex;
    }

    private void findNext(long currentReference) {
        for (int i = 0; i < this.cursors.length; ++i) {
            long otherReference;
            CURSOR cursor;
            if (i == this.currentCursorIndex || (cursor = this.cursors[i]) == null || (otherReference = this.reference(cursor)) == -1L) continue;
            if (this.compare(currentReference, otherReference)) {
                currentReference = otherReference;
                this.currentCursorIndex = i;
                continue;
            }
            if (otherReference != currentReference || cursor.next()) continue;
            this.cursors[i] = null;
        }
    }

    private boolean initialize() {
        long currentReference = this.extremeValue();
        for (int i = 0; i < this.cursors.length; ++i) {
            CURSOR cursor = this.cursors[i];
            if (cursor != null && cursor.next()) {
                long otherReference = this.reference(cursor);
                if (this.compare(currentReference, otherReference)) {
                    currentReference = otherReference;
                    this.currentCursorIndex = i;
                    continue;
                }
                if (otherReference != currentReference || cursor.next()) continue;
                this.cursors[i] = null;
                continue;
            }
            this.cursors[i] = null;
        }
        return currentReference != this.extremeValue();
    }

    public void setTracer(KernelReadTracer tracer) {
        for (CURSOR cursor : this.cursors) {
            if (cursor == null) continue;
            cursor.setTracer(tracer);
        }
    }

    public void removeTracer() {
        for (CURSOR cursor : this.cursors) {
            if (cursor == null) continue;
            cursor.removeTracer();
        }
    }

    public long reference() {
        Preconditions.checkArgument((this.cursors[this.currentCursorIndex] != null ? 1 : 0) != 0, (String)"Calling `reference` after `next` has returned `false` is not allowed");
        return this.reference(this.cursors[this.currentCursorIndex]);
    }

    protected CURSOR current() {
        return this.cursors[this.currentCursorIndex];
    }

    public void closeInternal() {
    }

    public boolean isClosed() {
        return false;
    }
}

