/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.io.Serializable;
import java.util.List;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.tuple.primitive.LongObjectPair;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.DataManager;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeData;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.NodeJuxtaposition;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.ProductGraphTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.memory.MemoryTracker;

final class BFSExpander
implements AutoCloseable {
    private final MemoryTracker mt;
    private final PPBFSHooks hooks;
    private final DataManager dataManager;
    private final ProductGraphTraversalCursor pgCursor;
    private final long intoTarget;
    private final HeapTrackingArrayList<State> statesList;

    public BFSExpander(DataManager dataManager, ProductGraphTraversalCursor pgCursor, long intoTarget, PPBFSHooks hooks, MemoryTracker mt) {
        this.mt = mt;
        this.hooks = hooks;
        this.dataManager = dataManager;
        this.pgCursor = pgCursor;
        this.intoTarget = intoTarget;
        this.statesList = HeapTrackingArrayList.newArrayList((int)2, (MemoryTracker)mt);
    }

    public void floodInitialNodeJuxtapositions() {
        this.floodNodeJuxtapositions(0);
    }

    private void floodNodeJuxtapositions(int depthOfNextLevel) {
        this.dataManager.nodeDatas().forEachNodeInNextLevel((Procedure<? super NodeData>)(Procedure & Serializable)currentNode -> {
            State state = currentNode.state();
            for (NodeJuxtaposition nj : state.getNodeJuxtapositions()) {
                if (!nj.testNode(currentNode.id())) continue;
                NodeData nextNode = this.dataManager.getNodeData(currentNode.id(), nj.targetState().id());
                if (nextNode == null) {
                    nextNode = new NodeData(this.mt, currentNode.id(), nj.targetState(), depthOfNextLevel, this.dataManager, this.intoTarget);
                    this.dataManager.addToNextLevel(nextNode);
                }
                nextNode.addSourceSignpost(TwoWaySignpost.fromNodeJuxtaposition(currentNode, nextNode, depthOfNextLevel), depthOfNextLevel);
            }
        });
    }

    public void expandLevel(int depthOfNextLevel) {
        for (LongObjectPair pair : this.dataManager.nodeDatas().getCurrentLevelDGDatas().keyValuesView()) {
            long dgNodeId = pair.getOne();
            HeapTrackingArrayList pgNodeDatas = (HeapTrackingArrayList)pair.getTwo();
            this.statesList.clear();
            for (NodeData pgNodeInStateOrNull : pgNodeDatas) {
                if (pgNodeInStateOrNull == null) continue;
                this.statesList.add((Object)pgNodeInStateOrNull.state());
            }
            this.pgCursor.setNodeAndStates(dgNodeId, (List<State>)this.statesList);
            while (this.pgCursor.next()) {
                long foundNode = this.pgCursor.otherNodeReference();
                NodeData nextNode = this.dataManager.getNodeData(foundNode, this.pgCursor.targetState().id());
                if (nextNode == null) {
                    nextNode = new NodeData(this.mt, foundNode, this.pgCursor.targetState(), depthOfNextLevel, this.dataManager, this.intoTarget);
                    this.dataManager.addToNextLevel(nextNode);
                }
                NodeData currentNode = (NodeData)pgNodeDatas.get(this.pgCursor.currentInputState().id());
                TwoWaySignpost.RelSignpost signpost = TwoWaySignpost.fromRelExpansion(currentNode, this.pgCursor.relationshipReference(), nextNode, this.pgCursor.relationshipExpansion(), depthOfNextLevel);
                nextNode.addSourceSignpost(signpost, depthOfNextLevel);
            }
        }
        this.floodNodeJuxtapositions(depthOfNextLevel);
    }

    public void setTracer(KernelReadTracer tracer) {
        this.pgCursor.setTracer(tracer);
    }

    @Override
    public void close() throws Exception {
        this.pgCursor.close();
        this.statesList.close();
    }
}

