/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.BitSet;
import java.util.function.Consumer;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.internal.kernel.api.helpers.traversal.SlotOrName;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.DataManager;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public final class NodeData
implements AutoCloseable {
    private static final int SIGNPOSTS_INIT_SIZE = 2;
    private final long id;
    private final State state;
    final DataManager dataManager;
    private final HeapTrackingArrayList<TwoWaySignpost> sourceSignposts;
    private HeapTrackingArrayList<TwoWaySignpost> targetSignposts;
    private final BitSet lengthsFromSource;
    private final BitSet validatedLengthsFromSource;
    private final int distanceFromSource;
    private int remainingTargetCount = 0;
    private boolean isTarget = false;

    public NodeData(MemoryTracker mt, long id, State state, int distanceFromSource, DataManager dataManager, long intoTarget) {
        this.sourceSignposts = HeapTrackingArrayList.newArrayList((int)2, (MemoryTracker)mt);
        this.id = id;
        this.state = state;
        this.distanceFromSource = distanceFromSource;
        this.dataManager = dataManager;
        this.lengthsFromSource = new BitSet();
        this.validatedLengthsFromSource = new BitSet();
        if (this.state().isFinalState() && (intoTarget == -1L || intoTarget == id)) {
            this.remainingTargetCount = (int)dataManager.initialCountForTargetNodes;
            this.isTarget = true;
            dataManager.incrementLiveTargetCount();
        }
    }

    public State state() {
        return this.state;
    }

    public boolean isTarget() {
        return this.isTarget;
    }

    public int nextSignpostIndexForLength(int currentIndex, int lengthFromSource) {
        for (int i = currentIndex + 1; i < this.sourceSignposts.size(); ++i) {
            if (!((TwoWaySignpost)this.sourceSignposts.get(i)).hasSourceLength(lengthFromSource)) continue;
            return i;
        }
        return -1;
    }

    public TwoWaySignpost getSourceSignpost(int index) {
        return (TwoWaySignpost)this.sourceSignposts.get(index);
    }

    public void synchronizeLength(int lengthFromSource) {
        for (int i = 0; i < this.sourceSignposts.size(); ++i) {
            if (!((TwoWaySignpost)this.sourceSignposts.get(i)).hasSourceLength(lengthFromSource)) continue;
            return;
        }
        assert (!this.validatedLengthsFromSource.get(lengthFromSource)) : "We should never remove validated length states";
        this.lengthsFromSource.set(lengthFromSource, false);
    }

    public boolean validatedAtLength(int lengthFromSource) {
        return this.validatedLengthsFromSource.get(lengthFromSource);
    }

    @Override
    public void close() {
        this.sourceSignposts.close();
        if (this.targetSignposts != null) {
            this.targetSignposts.close();
        }
    }

    public long id() {
        return this.id;
    }

    public void addSourceSignpost(TwoWaySignpost sourceSignpost, int lengthFromSource) {
        Preconditions.checkArgument((sourceSignpost.forwardNode == this ? 1 : 0) != 0, (String)"Source signpost must be added to correct node");
        this.dataManager.hooks.addSourceSignpost(sourceSignpost, lengthFromSource);
        if (!this.lengthsFromSource.get(lengthFromSource)) {
            this.lengthsFromSource.set(lengthFromSource);
            int minDistToTarget = this.minDistToTarget();
            if (minDistToTarget != -1) {
                Preconditions.checkState((lengthFromSource > this.distanceFromSource ? 1 : 0) != 0, (String)"When we find a shortest path to a node we shouldn't have TargetSignposts");
                this.dataManager.schedulePropagation(this, lengthFromSource, minDistToTarget);
            }
            if (this.isTarget()) {
                this.dataManager.addTarget(this);
            }
        } else assert (lengthFromSource == this.lengthsFromSource.stream().max().orElseThrow()) : "A node should only be seen by the BFS at increasingly deeper levels.";
        this.sourceSignposts.add((Object)sourceSignpost);
    }

    public void newPropagatedLengthFromSource(int lengthFromSource, int lengthToTarget) {
        if (!this.lengthsFromSource.get(lengthFromSource)) {
            this.lengthsFromSource.set(lengthFromSource);
            if (this.hasMinDistToTarget(lengthToTarget)) {
                Preconditions.checkState((lengthFromSource > this.distanceFromSource ? 1 : 0) != 0, (String)"When we find a shortest path to a node we shouldn't have TargetSignposts");
                this.dataManager.schedulePropagation(this, lengthFromSource, lengthToTarget);
            }
            if (this.isTarget()) {
                this.dataManager.addTarget(this);
            }
        }
    }

    public void addTargetSignpost(TwoWaySignpost targetSignpost, int lengthToTarget) {
        this.dataManager.hooks.addTargetSignpost(targetSignpost, lengthToTarget);
        Preconditions.checkArgument((targetSignpost.prevNode == this ? 1 : 0) != 0, (String)"Target signpost must be added to correct node");
        boolean firstTrace = false;
        if (this.targetSignposts == null) {
            this.targetSignposts = HeapTrackingArrayList.newArrayList((int)2, (MemoryTracker)this.dataManager.mt);
            firstTrace = true;
        }
        assert (!firstTrace || lengthToTarget >= this.minDistToTarget()) : "The first time a node is traced should be with the shortest trail to a target";
        if (!this.hasMinDistToTarget(lengthToTarget)) {
            int lengthFromSource = this.lengthsFromSource.nextSetBit(0);
            while (lengthFromSource != -1) {
                Preconditions.checkState((boolean)this.lengthsFromSource.get(lengthFromSource), (String)"");
                if ((firstTrace || this.validatedLengthsFromSource.get(lengthFromSource)) && lengthFromSource != this.distanceFromSource) {
                    this.dataManager.schedulePropagation(this, lengthFromSource, lengthToTarget);
                }
                lengthFromSource = this.lengthsFromSource.nextSetBit(lengthFromSource + 1);
            }
        }
        this.targetSignposts.add((Object)targetSignpost);
    }

    public void propagateLengthPair(int lengthFromSource, int lengthToTarget) {
        this.dataManager.hooks.propagateLengthPair(this, lengthFromSource, lengthToTarget);
        if (!this.hasAnyMinDistToTarget()) {
            return;
        }
        this.forEachTargetSignpost(signpost -> {
            if (signpost.minDistToTarget() == lengthToTarget) {
                signpost.propagate(lengthFromSource, lengthToTarget);
            }
        });
    }

    public void validateLengthState(int lengthFromSource, int tracedLengthToTarget) {
        this.dataManager.hooks.validateLengthState(this, lengthFromSource, tracedLengthToTarget);
        Preconditions.checkState((!this.validatedLengthsFromSource.get(lengthFromSource) ? 1 : 0) != 0, (String)"Shouldn't validate the same length from source more than once");
        assert (this.hasAnyMinDistToTarget() || tracedLengthToTarget == 0 && this.isTarget()) : "We only validate length states during tracing, and any traced node which isn't the target node of a path should've had a TargetSignpost registered in targetSignpostsByMinDist before being validated";
        assert (this.isTarget() && tracedLengthToTarget == 0 || tracedLengthToTarget == this.minDistToTarget()) : "First time tracing should be with shortest length to target";
        this.validatedLengthsFromSource.set(lengthFromSource);
        this.forEachTargetSignpost(tsp -> {
            int lengthToTarget = tsp.minDistToTarget();
            if (lengthToTarget != -1) {
                Preconditions.checkState((lengthToTarget >= tracedLengthToTarget ? 1 : 0) != 0, (String)"First time tracing should be with shortest length to target");
                if (lengthToTarget > tracedLengthToTarget) {
                    this.dataManager.schedulePropagation(this, lengthFromSource, lengthToTarget);
                }
            }
        });
    }

    public boolean decrementTargetCount() {
        this.dataManager.hooks.decrementTargetCount(this, this.remainingTargetCount);
        --this.remainingTargetCount;
        Preconditions.checkState((this.remainingTargetCount >= 0 ? 1 : 0) != 0, (String)"Target count should never be negative");
        if (this.remainingTargetCount == 0) {
            this.dataManager.decrementLiveTargetCount();
            return true;
        }
        return false;
    }

    public boolean hasMinDistToTarget(int minDistToTarget) {
        if (this.targetSignposts == null) {
            return false;
        }
        for (TwoWaySignpost tsp : this.targetSignposts) {
            if (tsp.minDistToTarget() != minDistToTarget) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyMinDistToTarget() {
        boolean res = this.targetSignposts != null;
        Preconditions.checkState((!res || this.targetSignposts.notEmpty() ? 1 : 0) != 0, (String)"If targetSignposts isn't null it's never supposed to be empty");
        return res;
    }

    public void forEachTargetSignpost(Consumer<TwoWaySignpost> f) {
        if (this.targetSignposts != null) {
            for (TwoWaySignpost tsp : this.targetSignposts) {
                f.accept(tsp);
            }
        }
    }

    private int minDistToTarget() {
        if (this.targetSignposts == null) {
            return -1;
        }
        int min = Integer.MAX_VALUE;
        for (TwoWaySignpost tsp : this.targetSignposts) {
            int curr = tsp.minDistToTarget();
            if (curr == -1 || curr >= min) continue;
            min = curr;
        }
        return min == Integer.MAX_VALUE ? -1 : min;
    }

    public String toString() {
        String stateName = String.valueOf(this.state.id());
        SlotOrName slotOrName = this.state.slotOrName();
        if (slotOrName instanceof SlotOrName.VarName) {
            SlotOrName.VarName name = (SlotOrName.VarName)slotOrName;
            stateName = name.name();
        }
        return "(" + this.id + "," + stateName + ")";
    }

    public int remainingTargetCount() {
        return this.remainingTargetCount;
    }
}

