/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingIntObjectHashMap;
import org.neo4j.collection.trackable.HeapTrackingUnifiedSet;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.HeapTrackingNodeDatas;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeData;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PGPathPropagatingBFS;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

final class DataManager
implements AutoCloseable {
    private final HeapTrackingNodeDatas nodeDatas;
    private final PGPathPropagatingBFS ppbfs;
    private final HeapTrackingArrayList<NodeData> targets;
    private final HeapTrackingIntObjectHashMap<HeapTrackingIntObjectHashMap<HeapTrackingUnifiedSet<NodeData>>> nodesToPropagate;
    final MemoryTracker mt;
    final PPBFSHooks hooks;
    final long initialCountForTargetNodes;
    private int liveTargets = 0;

    public DataManager(MemoryTracker memoryTracker, PPBFSHooks hooks, PGPathPropagatingBFS ppbfs, int initialCountForTargetNodes, int numberOfNFAStates) {
        this.ppbfs = ppbfs;
        this.mt = memoryTracker;
        this.hooks = hooks;
        this.nodeDatas = new HeapTrackingNodeDatas(memoryTracker, numberOfNFAStates);
        this.nodesToPropagate = HeapTrackingIntObjectHashMap.createIntObjectHashMap((MemoryTracker)memoryTracker);
        this.targets = HeapTrackingArrayList.newArrayList((MemoryTracker)memoryTracker);
        this.initialCountForTargetNodes = initialCountForTargetNodes;
    }

    public void incrementLiveTargetCount() {
        ++this.liveTargets;
    }

    public void decrementLiveTargetCount() {
        --this.liveTargets;
        Preconditions.checkState((this.liveTargets >= 0 ? 1 : 0) != 0, (String)"Live target count should never be negative");
    }

    public boolean hasLiveTargets() {
        return this.liveTargets > 0;
    }

    public void addToNextLevel(NodeData node) {
        this.nodeDatas.addToNextLevel(node);
    }

    public void allocateNextLevel() {
        this.nodeDatas.allocateNextLevel();
    }

    @Override
    public void close() {
        this.nodeDatas.close();
        this.nodesToPropagate.forEach((Procedure & Serializable)map -> {
            map.forEach(HeapTrackingUnifiedSet::close);
            map.close();
        });
        this.nodesToPropagate.close();
        this.targets.close();
    }

    public HeapTrackingNodeDatas nodeDatas() {
        return this.nodeDatas;
    }

    public NodeData getNodeData(long nodeId, int stateId) {
        return this.nodeDatas.get(nodeId, stateId);
    }

    public void schedulePropagation(NodeData nodeData, int lengthFromSource, int lengthToTarget) {
        this.hooks.schedulePropagation(nodeData, lengthFromSource, lengthToTarget);
        ((HeapTrackingUnifiedSet)((HeapTrackingIntObjectHashMap)this.nodesToPropagate.getIfAbsentPut(lengthFromSource + lengthToTarget, (Function0 & Serializable)() -> HeapTrackingIntObjectHashMap.createIntObjectHashMap((MemoryTracker)this.mt))).getIfAbsentPut(lengthFromSource, (Function0 & Serializable)() -> HeapTrackingUnifiedSet.createUnifiedSet((MemoryTracker)this.mt))).add((Object)nodeData);
    }

    public void propagateAll(int totalLength) {
        int minLengthFromSourceToPropagate;
        this.hooks.propagateAll(this.nodesToPropagate, totalLength);
        HeapTrackingIntObjectHashMap nodesToPropagateForLength = (HeapTrackingIntObjectHashMap)this.nodesToPropagate.get(totalLength);
        if (nodesToPropagateForLength == null) {
            return;
        }
        for (int lengthFromSource = minLengthFromSourceToPropagate = nodesToPropagateForLength.keysView().min(); lengthFromSource <= totalLength; ++lengthFromSource) {
            int lengthToTarget = totalLength - lengthFromSource;
            this.hooks.propagateAllAtLengths(lengthFromSource, lengthToTarget);
            HeapTrackingUnifiedSet nodesToPropagateAtLengthPair = (HeapTrackingUnifiedSet)nodesToPropagateForLength.get(lengthFromSource);
            if (nodesToPropagateAtLengthPair == null) continue;
            while (nodesToPropagateAtLengthPair.notEmpty()) {
                NodeData node = (NodeData)nodesToPropagateAtLengthPair.getLast();
                nodesToPropagateAtLengthPair.remove((Object)node);
                node.propagateLengthPair(lengthFromSource, lengthToTarget);
            }
            nodesToPropagateForLength.remove(lengthFromSource);
            nodesToPropagateAtLengthPair.close();
        }
        ((HeapTrackingIntObjectHashMap)this.nodesToPropagate.remove(totalLength)).close();
        this.hooks.finishedPropagation(this.targets);
    }

    public boolean hasNodesToPropagateOrExpand() {
        assert (this.nodesToPropagate.isEmpty() || this.nodesToPropagate.keysView().min() >= this.ppbfs.nextDepth()) : "The current implementation is structured such that we never should schedule nodes to propagate for a depth which has already passed. If we do (as the algo is implemented here), we will loop for ever.";
        return this.nodeDatas.currentLevelHasNodes() || this.nodesToPropagate.notEmpty();
    }

    public void addTarget(NodeData nodeData) {
        Preconditions.checkArgument((boolean)nodeData.isTarget(), (String)"Node must be a target");
        Preconditions.checkState((!this.targets.contains((Object)nodeData) ? 1 : 0) != 0, (String)"Caller is responsible for adding any node as a target at most once per level");
        this.targets.add((Object)nodeData);
    }

    public HeapTrackingArrayList<NodeData> targets() {
        return this.targets;
    }

    public boolean hasTargetsWithRemainingCount() {
        for (NodeData t : this.targets) {
            if (t.remainingTargetCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasNodesToExpand() {
        return this.nodeDatas.currentLevelHasNodes();
    }

    public boolean hasTargets() {
        return this.targets.notEmpty();
    }

    public void clearTargets() {
        this.targets.clear();
    }
}

