/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.BFSExpander;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.DataManager;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeData;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PathTracer;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public final class PGPathPropagatingBFS
implements AutoCloseable {
    private final DataManager dataManager;
    private final BFSExpander bfsExpander;
    private final NodeData sourceData;
    private final long intoTarget;
    private final PathTracer pathTracer;
    private final PPBFSHooks hooks;
    private int nextDepth = 0;
    private boolean isInitialLevel = true;

    public PGPathPropagatingBFS(long source, long intoTarget, State startState, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, PathTracer pathTracer, int initialCountForTargetNodes, int numberOfNfaStates, MemoryTracker mt, PPBFSHooks hooks) {
        this.intoTarget = intoTarget;
        this.pathTracer = pathTracer;
        this.hooks = hooks;
        this.dataManager = new DataManager(mt, hooks, this, initialCountForTargetNodes, numberOfNfaStates);
        this.bfsExpander = new BFSExpander(this.dataManager, read, nodeCursor, relCursor, mt, hooks, intoTarget);
        this.sourceData = new NodeData(mt, source, startState, 0, this.dataManager, intoTarget);
        this.dataManager.addToNextLevel(this.sourceData);
        this.hooks.newRow(source);
    }

    public int nextDepth() {
        return this.nextDepth;
    }

    public <Row> Iterator<Row> iterate(final Function<PathTracer.TracedPath, Row> toRow, final Predicate<Row> nonInlinedPredicate, final Boolean isGroupSelector) {
        this.pathTracer.setSourceNode(this.sourceData);
        return new PrefetchingIterator<Row>(){
            private Iterator<NodeData> currentTargets = Collections.emptyIterator();
            private boolean done = false;

            protected Row fetchNextOrNull() {
                if (this.done) {
                    return null;
                }
                while (true) {
                    if (PGPathPropagatingBFS.this.pathTracer.ready()) {
                        while (PGPathPropagatingBFS.this.pathTracer.hasNext()) {
                            PathTracer.TracedPath path = (PathTracer.TracedPath)PGPathPropagatingBFS.this.pathTracer.next();
                            Object row = toRow.apply(path);
                            if (!nonInlinedPredicate.test(row)) continue;
                            if (!isGroupSelector.booleanValue()) {
                                PGPathPropagatingBFS.this.pathTracer.decrementTargetCount();
                            } else if (!PGPathPropagatingBFS.this.pathTracer.hasNext()) {
                                PGPathPropagatingBFS.this.pathTracer.decrementTargetCount();
                            }
                            if (PGPathPropagatingBFS.this.intoTarget != -1L && PGPathPropagatingBFS.this.pathTracer.isSaturated()) {
                                this.done = true;
                            }
                            return row;
                        }
                    }
                    if (!this.currentTargets.hasNext()) {
                        if (PGPathPropagatingBFS.this.nextLevelWithTargets()) {
                            this.currentTargets = PGPathPropagatingBFS.this.dataManager.targets().iterator();
                        } else {
                            this.done = true;
                            return null;
                        }
                    }
                    PGPathPropagatingBFS.this.pathTracer.resetWithNewTargetNodeAndDGLength(this.currentTargets.next(), PGPathPropagatingBFS.this.nextDepth);
                }
            }
        };
    }

    private boolean nextLevelWithTargets() {
        if (this.zeroHopLevel()) {
            return true;
        }
        do {
            if (this.shouldQuit()) {
                return false;
            }
            if (this.nextLevel()) continue;
            return false;
        } while (!this.dataManager.hasTargets());
        return true;
    }

    private boolean shouldQuit() {
        return !this.dataManager.hasLiveTargets() && !this.dataManager.hasNodesToExpand();
    }

    private boolean nextLevel() {
        ++this.nextDepth;
        this.hooks.nextLevel(this.nextDepth);
        this.dataManager.clearTargets();
        if (!this.dataManager.hasNodesToPropagateOrExpand()) {
            this.hooks.noMoreNodes();
            return false;
        }
        if (this.dataManager.hasNodesToExpand()) {
            this.bfsExpander.expandLevel(this.nextDepth);
            this.dataManager.allocateNextLevel();
        }
        this.dataManager.propagateAll(this.nextDepth);
        return true;
    }

    private boolean zeroHopLevel() {
        if (!this.isInitialLevel) {
            return false;
        }
        this.isInitialLevel = false;
        Preconditions.checkState((this.nextDepth == 0 ? 1 : 0) != 0, (String)"zeroHopLevel called for nonzero depth");
        this.hooks.nextLevel(0);
        this.bfsExpander.floodInitialNodeJuxtapositions();
        this.dataManager.allocateNextLevel();
        if (this.sourceData.isTarget()) {
            this.dataManager.addTarget(this.sourceData);
        }
        return this.dataManager.hasTargetsWithRemainingCount();
    }

    public void setTracer(KernelReadTracer tracer) {
        this.bfsExpander.setTracer(tracer);
    }

    @Override
    public void close() throws Exception {
        this.bfsExpander.close();
        this.dataManager.close();
    }
}

