/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.productgraph;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.Transition;

public final class RelationshipExpansion
implements Transition {
    private final Predicate<RelationshipTraversalCursor> relPredicate;
    private final int[] types;
    private final Direction direction;
    private final State.VarName relName;
    private final LongPredicate nodePredicate;
    private State targetState;

    public RelationshipExpansion(Predicate<RelationshipTraversalCursor> relPredicate, int[] types, Direction direction, State.VarName relName, LongPredicate nodePredicate, State targetState) {
        this.relPredicate = relPredicate;
        this.types = types;
        this.direction = direction;
        this.relName = relName;
        this.nodePredicate = nodePredicate;
        this.targetState = targetState;
    }

    public boolean testRelationship(RelationshipTraversalCursor cursor) {
        return this.relPredicate.test(cursor);
    }

    public boolean testNode(long node) {
        return this.nodePredicate.test(node);
    }

    public int[] types() {
        return this.types;
    }

    public Direction direction() {
        return this.direction;
    }

    public State.VarName relName() {
        return this.relName;
    }

    @Override
    public State targetState() {
        return this.targetState;
    }

    @Override
    public void setTargetState(State state) {
        assert (this.targetState == null) : "Shouldn't set target state more than once. The targetState field is only mutable to support delayed initialization which is require when there are cycles in the NFA";
        this.targetState = state;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RelationshipExpansion that = (RelationshipExpansion)obj;
        return Objects.equals(this.relPredicate, that.relPredicate) && Arrays.equals(this.types, that.types) && Objects.equals(this.direction, that.direction) && Objects.equals(this.relName, that.relName) && Objects.equals(this.nodePredicate, that.nodePredicate) && Objects.equals(this.targetState, that.targetState);
    }

    public int hashCode() {
        return Objects.hash(this.relPredicate, Arrays.hashCode(this.types), this.direction, this.relName, this.nodePredicate, this.targetState);
    }

    public String toString() {
        return "RelationshipExpansion[relPredicate=" + this.relPredicate + ", types=" + Arrays.toString(this.types) + ", direction=" + this.direction + ", relName=" + this.relName + ", nodePredicate=" + this.nodePredicate + ", targetState=" + this.targetState + "]";
    }
}

