/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.kernel.impl.util.NodeEntityWrappingNodeValue;
import org.neo4j.kernel.impl.util.RelationshipEntityWrappingValue;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.NodeReference;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public final class ValuePopulation {
    private static final NodeValue MISSING_NODE = VirtualValues.nodeValue((long)-1L, (TextArray)Values.EMPTY_TEXT_ARRAY, (MapValue)VirtualValues.EMPTY_MAP, (boolean)false);

    private ValuePopulation() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static AnyValue populate(AnyValue value, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relCursor, PropertyCursor propertyCursor) {
        if (value instanceof VirtualNodeValue) {
            return ValuePopulation.populate((VirtualNodeValue)value, dbAccess, nodeCursor, propertyCursor);
        }
        if (value instanceof VirtualRelationshipValue) {
            return ValuePopulation.populate((VirtualRelationshipValue)value, dbAccess, nodeCursor, relCursor, propertyCursor);
        }
        if (value instanceof VirtualPathValue) {
            return ValuePopulation.populate((VirtualPathValue)value, dbAccess, nodeCursor, relCursor, propertyCursor);
        }
        if (value instanceof ListValue) {
            return ValuePopulation.populate((ListValue)value, dbAccess, nodeCursor, relCursor, propertyCursor);
        }
        if (value instanceof MapValue) {
            return ValuePopulation.populate((MapValue)value, dbAccess, nodeCursor, relCursor, propertyCursor);
        }
        return value;
    }

    public static NodeValue populate(VirtualNodeValue value, DbAccess dbAccess, NodeCursor nodeCursor, PropertyCursor propertyCursor) {
        if (value instanceof NodeEntityWrappingNodeValue) {
            NodeEntityWrappingNodeValue wrappingNodeValue = (NodeEntityWrappingNodeValue)value;
            wrappingNodeValue.populate(nodeCursor, propertyCursor);
            return wrappingNodeValue;
        }
        if (value instanceof NodeValue) {
            return (NodeValue)value;
        }
        return ValuePopulation.nodeValue(value.id(), dbAccess, nodeCursor, propertyCursor);
    }

    public static RelationshipValue populate(VirtualRelationshipValue value, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relCursor, PropertyCursor propertyCursor) {
        if (value instanceof RelationshipEntityWrappingValue) {
            RelationshipEntityWrappingValue wrappingValue = (RelationshipEntityWrappingValue)value;
            wrappingValue.populate(relCursor, propertyCursor);
            return wrappingValue;
        }
        if (value instanceof RelationshipValue) {
            return (RelationshipValue)value;
        }
        return ValuePopulation.relationshipValue(value.id(), dbAccess, nodeCursor, relCursor, propertyCursor);
    }

    public static PathValue populate(VirtualPathValue value, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relCursor, PropertyCursor propertyCursor) {
        NodeValue nodeValue;
        int i;
        if (value instanceof PathValue) {
            return (PathValue)value;
        }
        long[] nodeIds = value.nodeIds();
        long[] relIds = value.relationshipIds();
        NodeValue[] nodes = new NodeValue[nodeIds.length];
        RelationshipValue[] rels = new RelationshipValue[relIds.length];
        long payloadSize = 0L;
        for (i = 0; i < rels.length; ++i) {
            nodeValue = ValuePopulation.nodeValue(nodeIds[i], dbAccess, nodeCursor, propertyCursor);
            RelationshipValue relationshipValue = ValuePopulation.relationshipValue(relIds[i], dbAccess, nodeCursor, relCursor, propertyCursor);
            payloadSize += nodeValue.estimatedHeapUsage() + relationshipValue.estimatedHeapUsage();
            nodes[i] = nodeValue;
            rels[i] = relationshipValue;
        }
        nodeValue = ValuePopulation.nodeValue(nodeIds[i], dbAccess, nodeCursor, propertyCursor);
        nodes[i] = nodeValue;
        return VirtualValues.path((NodeValue[])nodes, (RelationshipValue[])rels, (long)(payloadSize += nodeValue.estimatedHeapUsage()));
    }

    public static MapValue populate(MapValue value, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relCursor, PropertyCursor propertyCursor) {
        MapValueBuilder builder = new MapValueBuilder();
        value.foreach((key, anyValue) -> builder.add(key, ValuePopulation.populate(anyValue, dbAccess, nodeCursor, relCursor, propertyCursor)));
        return builder.build();
    }

    public static ListValue populate(ListValue value, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relCursor, PropertyCursor propertyCursor) {
        ListValueBuilder builder = ListValueBuilder.newListBuilder((int)value.size());
        for (AnyValue v : value) {
            builder.add(ValuePopulation.populate(v, dbAccess, nodeCursor, relCursor, propertyCursor));
        }
        return builder.build();
    }

    private static NodeValue nodeValue(long id, DbAccess dbAccess, NodeCursor nodeCursor, PropertyCursor propertyCursor) {
        dbAccess.singleNode(id, nodeCursor);
        if (!nodeCursor.next()) {
            return VirtualValues.nodeValue((long)id, (TextArray)Values.EMPTY_TEXT_ARRAY, (MapValue)VirtualValues.EMPTY_MAP, (boolean)true);
        }
        nodeCursor.properties(propertyCursor);
        return VirtualValues.nodeValue((long)id, (TextArray)ValuePopulation.labels(dbAccess, nodeCursor.labels()), (MapValue)ValuePopulation.properties(propertyCursor, dbAccess));
    }

    private static RelationshipValue relationshipValue(long id, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relCursor, PropertyCursor propertyCursor) {
        dbAccess.singleRelationship(id, relCursor);
        if (!relCursor.next()) {
            return VirtualValues.relationshipValue((long)id, (VirtualNodeValue)MISSING_NODE, (VirtualNodeValue)MISSING_NODE, (TextValue)Values.EMPTY_STRING, (MapValue)VirtualValues.EMPTY_MAP, (boolean)true);
        }
        NodeReference start = VirtualValues.node((long)relCursor.sourceNodeReference());
        NodeReference end = VirtualValues.node((long)relCursor.targetNodeReference());
        relCursor.properties(propertyCursor);
        return VirtualValues.relationshipValue((long)id, (VirtualNodeValue)start, (VirtualNodeValue)end, (TextValue)Values.stringValue((String)dbAccess.relationshipTypeName(relCursor.type())), (MapValue)ValuePopulation.properties(propertyCursor, dbAccess));
    }

    private static TextArray labels(DbAccess dbAccess, TokenSet labelsTokens) {
        String[] labels = new String[labelsTokens.numberOfTokens()];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = dbAccess.nodeLabelName(labelsTokens.token(i));
        }
        return Values.stringArray((String[])labels);
    }

    private static MapValue properties(PropertyCursor propertyCursor, DbAccess dbAccess) {
        MapValueBuilder builder = new MapValueBuilder();
        while (propertyCursor.next()) {
            builder.add(dbAccess.propertyKeyName(propertyCursor.propertyKey()), (AnyValue)propertyCursor.propertyValue());
        }
        return builder.build();
    }
}

